/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.pojo;

import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.util.XmlUtil;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Section {
    private static final Logger log = Logger.getLogger(Section.class);
    public static final String ELEMENT = "section";
    public static final String ATTRIBUTE_ID = "id";
    private String cls_ReferenceName = "";
    private int cls_Id = 0;
    private final Vector<Setting> cls_Settings = new Vector();
    private Setting[] cls_SettingsArray = null;

    public void setReferenceName(String string) {
        this.cls_ReferenceName = string;
    }

    public String getReferenceName() {
        return this.cls_ReferenceName;
    }

    public void setId(int n) {
        this.cls_Id = n;
    }

    public int getId() {
        return this.cls_Id;
    }

    public int getSettingCount() {
        return this.cls_Settings.size();
    }

    public Setting[] getSettings() {
        if (this.cls_SettingsArray != null) {
            return this.cls_SettingsArray;
        }
        Setting[] settingArray = new Setting[this.cls_Settings.size()];
        this.cls_Settings.toArray(settingArray);
        this.cls_SettingsArray = settingArray;
        return this.cls_SettingsArray;
    }

    public Setting getSetting(int n) {
        if (n < 0 || n >= this.cls_Settings.size()) {
            return null;
        }
        return this.cls_Settings.elementAt(n);
    }

    public void addSetting(Setting setting) {
        log.debug((Object)("    - [" + this.getReferenceName() + "-" + this.getId() + "] Adding Setting: " + (Object)((Object)setting.getSettingId())));
        if (setting instanceof Setting) {
            this.cls_SettingsArray = null;
            this.cls_Settings.add(setting);
        } else {
            log.error((Object)"Attempted to add a null setting.  Will discard.");
        }
    }

    public Setting getSettingById(Settings.SettingId settingId) {
        for (int i = 0; i < this.cls_Settings.size(); ++i) {
            if (settingId != this.cls_Settings.elementAt(i).getSettingId()) continue;
            return this.cls_Settings.elementAt(i);
        }
        return null;
    }

    public Setting[] getSettingsById(Settings.SettingId settingId) {
        ArrayList<Setting> arrayList = new ArrayList<Setting>();
        for (int i = 0; i < this.cls_Settings.size(); ++i) {
            if (settingId != this.cls_Settings.elementAt(i).getSettingId()) continue;
            arrayList.add(this.cls_Settings.elementAt(i));
        }
        Setting[] settingArray = new Setting[arrayList.size()];
        arrayList.toArray(settingArray);
        return settingArray;
    }

    public String getXml() {
        return this.getXml(false);
    }

    public String getXml(boolean bl) {
        String string = "";
        string = "<section" + XmlUtil.createAttribute(ATTRIBUTE_ID, this.getId()) + ">" + '\n';
        for (int i = 0; i < this.cls_Settings.size(); ++i) {
            string = string + this.cls_Settings.elementAt(i).getXml(bl, false);
        }
        string = string + XmlUtil.createElementClose(ELEMENT);
        return string;
    }

    public String toString() {
        return "[Section id=" + this.getId() + "]";
    }
}

