/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.pojo;

import com.cloudpath.assess.pojo.Condition;
import com.cloudpath.assess.pojo.Option;
import com.cloudpath.assess.pojo.Options;
import com.cloudpath.assess.pojo.Section;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.compare.VersionCompare;
import com.cloudpath.common.util.Constants;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.common.util.Xmlable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Profile
implements Xmlable {
    private static final Logger log = Logger.getLogger(Profile.class);
    public static final String ELEMENT_PROFILE = "profile";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALIDATION_URL = "validation_url";
    public static final String ELEMENT_VALIDATION_GREP = "validation_grep";
    public static final String ATTRIBUTE_PRE_RUNAS = "pre_runas";
    public static final String ELEMENT_PRE_SCRIPT = "pre_transition_script";
    public static final String ATTRIBUTE_POST_RUNAS = "post_runas";
    public static final String ELEMENT_POST_SCRIPT = "post_transition_script";
    public static final String ATTRIBUTE_SHOW_PRE_CREDENTIALS = "show_pre_creds";
    public static final String ELEMENT_CONDITIONS = "conditions";
    public static final String ELEMENT_SECTIONS = "sections";
    public static final int DEFAULT_RUNAS = 0;
    public static final int DEFAULT_SHOW_PRE_CREDENTIALS = -1;
    private String cls_Name = "";
    private String cls_ValidationUrl = "";
    private String cls_ValidationGrep = "";
    private int cls_PreRunas = 0;
    private String cls_PreTransitionScript = "";
    private int cls_PostRunas = 0;
    private String cls_PostTransitionScript = "";
    private int cls_ShowPreCredentials = -1;
    private Options cls_Options = new Options();
    private final Vector<Condition> cls_Conditions = new Vector();
    private final Vector<Section> cls_Sections = new Vector();

    public void setName(String string) {
        this.cls_Name = string != null ? string : "";
    }

    public String getName() {
        return this.cls_Name;
    }

    public void setPreRunas(int n) {
        this.cls_PreRunas = n;
    }

    public int getPreRunas() {
        return this.cls_PreRunas;
    }

    public void setPreTransitionScript(String string) {
        this.cls_PreTransitionScript = string != null ? string : "";
    }

    public String getPreTransitionScript() {
        return this.cls_PreTransitionScript;
    }

    public void setPostRunas(int n) {
        this.cls_PostRunas = n;
    }

    public int getPostRunas() {
        return this.cls_PostRunas;
    }

    public void setPostTransitionScript(String string) {
        this.cls_PostTransitionScript = string != null ? string : "";
    }

    public String getPostTransitionScript() {
        return this.cls_PostTransitionScript;
    }

    public void setValidationUrl(String string) {
        this.cls_ValidationUrl = string != null ? string : "";
    }

    public String getValidationUrl() {
        return this.cls_ValidationUrl;
    }

    public void setValidationGrep(String string) {
        this.cls_ValidationGrep = string != null ? string : "";
    }

    public String getValidationGrep() {
        return this.cls_ValidationGrep;
    }

    public void setShowPreCredentials(int n) {
        this.cls_ShowPreCredentials = n;
    }

    public int getShowPreCredentials() {
        return this.cls_ShowPreCredentials;
    }

    public int getConditionCount() {
        return this.cls_Conditions.size();
    }

    public void addCondition(Condition condition) {
        this.cls_Conditions.add(condition);
    }

    public Condition getCondition(int n) {
        if (n < 0 || n >= this.cls_Conditions.size()) {
            return null;
        }
        return this.cls_Conditions.elementAt(n);
    }

    public void addCondition(Condition.ConditionKey conditionKey, Condition.ConditionOperator conditionOperator, int n) {
        this.addCondition(conditionKey, conditionOperator, "" + n);
    }

    public void addCondition(Condition.ConditionKey conditionKey, Condition.ConditionOperator conditionOperator, String string) {
        Condition condition = new Condition();
        condition.setKey(conditionKey);
        condition.setOperator(conditionOperator);
        condition.setValue(string);
        this.addCondition(condition);
    }

    public int getSectionCount() {
        return this.cls_Sections.size();
    }

    public void addSection(Section section) {
        this.cls_Sections.add(section);
    }

    public Section getSection(int n) {
        if (n < 0 || n >= this.cls_Sections.size()) {
            return null;
        }
        return this.cls_Sections.elementAt(n);
    }

    public Options getOptions() {
        return this.cls_Options;
    }

    public void addOption(Option option) {
        this.cls_Options.setValue(option.getId(), option.getValue());
    }

    public String getSsid() {
        String string = "REPLACE_ME";
        return this.getAdditionalValueForSettingId(Settings.SettingId.WIRELESS_NETWORK_PROFILE, string);
    }

    public String getSecureW2ProfileName() {
        return this.getAdditionalValueForSettingId(Settings.SettingId.SECUREW2_PROFILE_NAME, "");
    }

    public String getAdditionalValueForSettingId(Settings.SettingId settingId, String string) {
        for (int i = 0; i < this.cls_Sections.size(); ++i) {
            for (int j = 0; j < this.cls_Sections.elementAt(i).getSettingCount(); ++j) {
                if (this.cls_Sections.elementAt(i).getSetting(j).getSettingId() != settingId) continue;
                return this.cls_Sections.elementAt(i).getSetting(j).getAdditionalValue();
            }
        }
        return string;
    }

    public String getXml() {
        return this.getXml(false);
    }

    public String getXml(boolean bl) {
        int n;
        String string = "<profile" + XmlUtil.createAttribute(ATTRIBUTE_PRE_RUNAS, this.getPreRunas(), 0) + XmlUtil.createAttribute(ATTRIBUTE_POST_RUNAS, this.getPostRunas(), 0) + XmlUtil.createAttribute(ATTRIBUTE_SHOW_PRE_CREDENTIALS, this.getShowPreCredentials(), -1) + ">" + '\n' + XmlUtil.createElement(ELEMENT_NAME, this.getName()) + XmlUtil.createElement(ELEMENT_VALIDATION_URL, this.getValidationUrl()) + XmlUtil.createElement(ELEMENT_VALIDATION_GREP, this.getValidationGrep()) + XmlUtil.createElement(ELEMENT_PRE_SCRIPT, this.getPreTransitionScript()) + XmlUtil.createElement(ELEMENT_POST_SCRIPT, this.getPostTransitionScript());
        string = string + XmlUtil.createElementOpen(ELEMENT_CONDITIONS);
        for (n = 0; n < this.cls_Conditions.size(); ++n) {
            string = string + this.getCondition(n).getXml();
        }
        string = string + XmlUtil.createElementClose(ELEMENT_CONDITIONS);
        string = string + XmlUtil.createElementOpen(ELEMENT_SECTIONS);
        for (n = 0; n < this.cls_Sections.size(); ++n) {
            string = string + this.cls_Sections.elementAt(n).getXml(bl);
        }
        string = string + XmlUtil.createElementClose(ELEMENT_SECTIONS);
        string = string + this.cls_Options.getXml();
        string = string + XmlUtil.createElementClose(ELEMENT_PROFILE);
        return string;
    }

    public int[] calculateSupportedInterfaceTypes() {
        int[] nArray = Constants.getAllInterfaceTypes();
        for (int i = 0; i < this.getConditionCount(); ++i) {
            nArray = this.getCondition(i).calculateSupportedInterfaceTypes(nArray);
        }
        return nArray;
    }

    public boolean isMatch(Condition[] conditionArray) {
        return this.isMatch(conditionArray, true);
    }

    public boolean isPotentialMatch(Condition[] conditionArray) {
        return this.isMatch(conditionArray, false);
    }

    private boolean isMatch(Condition[] conditionArray, boolean bl) {
        if (conditionArray == null) {
            return true;
        }
        for (int i = 0; i < this.getConditionCount(); ++i) {
            Condition.ConditionKey conditionKey = this.getCondition(i).getKey();
            boolean bl2 = false;
            for (int j = 0; j < conditionArray.length; ++j) {
                if (conditionArray[j] == null || !conditionArray[j].getKey().equals((Object)conditionKey)) continue;
                String string = this.getCondition(i).getValue();
                String string2 = conditionArray[j].getValue();
                bl2 = true;
                if ("*".equals(string) || Condition.ConditionOperator.NE.equals((Object)this.getCondition(i).getOperator()) && !string.equals(string2) || !Condition.ConditionOperator.NE.equals((Object)this.getCondition(i).getOperator()) && string.equals(string2)) continue;
                if (Condition.ConditionOperator.GE.equals((Object)this.getCondition(i).getOperator())) {
                    log.info((Object)("Will compare OS version; checking if OS version '" + string2 + "' >= '" + string2 + "'."));
                    int n = VersionCompare.compareVersions(VersionCompare.getSplitVersion(string2), VersionCompare.getSplitVersion(string));
                    boolean bl3 = n >= 0;
                    log.info((Object)("  - Result of version comparison is '" + bl3 + "'."));
                    return bl3;
                }
                return false;
            }
            if (!bl || bl2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    public Setting getSettingById(Settings.SettingId settingId) {
        for (int i = 0; i < this.getSectionCount(); ++i) {
            Setting setting;
            Section section = this.getSection(i);
            if (section == null || (setting = section.getSettingById(settingId)) == null) continue;
            return setting;
        }
        return null;
    }

    public boolean hasAtLeastOneSetting() {
        for (int i = 0; this.cls_Sections != null && i < this.cls_Sections.size(); ++i) {
            if (this.cls_Sections.get(i) == null || this.cls_Sections.get(i).getSettingCount() <= 0) continue;
            return true;
        }
        return false;
    }
}

