/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.pojo;

import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Option;
import com.cloudpath.assess.pojo.Options;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.common.pojo.Contact;
import com.cloudpath.common.pojo.IpSet;
import com.cloudpath.common.util.Constants;
import com.cloudpath.common.util.Encode;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.common.util.Xmlable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Network
implements Xmlable {
    private static final Logger log = Logger.getLogger(Network.class);
    public static final int EVAL_LICENSE = 1;
    public static final int PURCHASED_LICENSE = 2;
    public static final String ELEMENT_NETWORK = "network";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_DESCRIPTION = "description";
    public static final String ELEMENT_WELCOME_TITLE = "welcome_title";
    public static final String ATTRIBUTE_SUBNETS = "subnets";
    public static final String ATTRIBUTE_EXPIRATION = "expiration";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_CONTRACT_STATE = "contract_state";
    public static final String ATTRIBUTE_GUI_FLAGS = "gui_flags";
    public static final String ELEMENT_REFRESH_URL = "refresh_url";
    public static final String ELEMENT_LICENSEE = "licensee";
    public static final String ELEMENT_LICENSE = "license";
    public static final String ELEMENT_SERVER_ADDRESS = "server_address";
    public static final String ELEMENT_UNSUPPORTED_OS_MESSAGE = "unsupported_os_message";
    public static final String ELEMENT_UNSUPPORTED_OS_URL = "unsupported_os_url";
    public static final String ELEMENT_NETWORK_ITEMS = "network_items";
    private String cls_Version = "";
    private String cls_Name = "";
    private String cls_Description = "";
    private String cls_WelcomeTitle = "";
    private String cls_RefreshUrl = "";
    private String cls_Licensee = "";
    private String cls_LicenseKey = "";
    private String cls_ServerAddress = "";
    private String cls_UnsupportedOsMessage = "";
    private String cls_UnsupportedOsUrl = "";
    private boolean cls_IsLicensed = false;
    private String cls_ExpirationDate = "";
    private int cls_ContractState = 1;
    private Contact cls_Contact = new Contact();
    private IpSet cls_Subnets = new IpSet();
    private long cls_GuiFlags = 0L;
    private String cls_Licensor = "";
    private final Vector<NetworkItem> cls_NetworkItems = new Vector();
    private final Options cls_Options = new Options();

    private Network() {
    }

    public void setName(String string) {
        this.cls_Name = string;
    }

    public String getName() {
        return this.cls_Name;
    }

    public void setDescription(String string) {
        this.cls_Description = string;
    }

    public String getDescription() {
        return this.cls_Description;
    }

    public void setWelcomeTitle(String string) {
        this.cls_WelcomeTitle = string;
    }

    public String getWelcomeTitle() {
        return this.cls_WelcomeTitle;
    }

    public void setRefreshUrl(String string) {
        this.cls_RefreshUrl = string;
    }

    public String getRefreshUrl() {
        return this.cls_RefreshUrl;
    }

    public void setLicensee(String string) {
        this.cls_Licensee = string;
    }

    public String getLicensee() {
        return this.cls_Licensee;
    }

    public void setServerAddress(String string) {
        this.cls_ServerAddress = string;
    }

    public String getServerAddress() {
        return this.cls_ServerAddress;
    }

    public void setSubnets(String string) {
        this.cls_Subnets.parseList(string);
    }

    public IpSet getSubnets() {
        return this.cls_Subnets;
    }

    public void setExpirationDate(String string) {
        this.cls_ExpirationDate = string;
    }

    public String getExpirationDate() {
        return this.cls_ExpirationDate;
    }

    public void setUnsupportedOsMessage(String string) {
        this.cls_UnsupportedOsMessage = string;
    }

    public String getUnsupportedOsMessage() {
        return this.cls_UnsupportedOsMessage;
    }

    public void setUnsupportedOsUrl(String string) {
        this.cls_UnsupportedOsUrl = string;
    }

    public String getUnsupportedOsUrl() {
        return this.cls_UnsupportedOsUrl;
    }

    public void setContractState(int n) {
        this.cls_ContractState = n;
    }

    public int getContractState() {
        return this.cls_ContractState;
    }

    public void setGuiFlags(long l) {
        this.cls_GuiFlags = l >= 0L ? l : 0L;
    }

    public long getGuiFlags() {
        return this.cls_GuiFlags;
    }

    public void setVersion(String string) {
        this.cls_Version = string;
    }

    public String getVersion() {
        return this.cls_Version;
    }

    public boolean isLicensed() {
        return this.cls_IsLicensed;
    }

    public void removeLicense() {
        this.cls_IsLicensed = false;
    }

    public String getLicensor() {
        return this.cls_Licensor;
    }

    public void setLicensor(String string) {
        if (string != null && this.cls_Licensor.length() == 0) {
            this.cls_Licensor = string;
            this.cls_IsLicensed = true;
        }
    }

    public void setLicense(String string) {
        String string2;
        this.cls_LicenseKey = string;
        String string3 = Encode.encode(this.getInternalKeyData());
        this.cls_IsLicensed = string3.equals(string);
        if (this.cls_IsLicensed && this.cls_ExpirationDate.length() > 0 && (string2 = Constants.DATE_BASIC.format(System.currentTimeMillis())).compareTo(this.cls_ExpirationDate) > 0) {
            this.cls_IsLicensed = false;
        }
    }

    public boolean isAcceptableVersion() {
        return this.cls_Version.length() == 0 || this.cls_Version.equals("1");
    }

    public int getNetworkItemCount() {
        return this.cls_NetworkItems.size();
    }

    public int getNetworkItemCount(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.cls_NetworkItems.size(); ++i) {
            if (bl) {
                if (this.cls_NetworkItems.get(i).getIsHidden()) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    public void addNetworkItem(NetworkItem networkItem) {
        this.cls_NetworkItems.add(networkItem);
    }

    public NetworkItem getNetworkItem(int n) {
        if (n < 0 || n >= this.cls_NetworkItems.size()) {
            return null;
        }
        return this.cls_NetworkItems.elementAt(n);
    }

    public NetworkItem getNetworkItemByName(String string) {
        for (int i = 0; i < this.cls_NetworkItems.size(); ++i) {
            if (!this.getNetworkItem(i).getName().equals(string)) continue;
            return this.getNetworkItem(i);
        }
        return null;
    }

    public Options getOptions() {
        return this.cls_Options;
    }

    public void addOption(Option option) {
        this.cls_Options.setValue(option.getId(), option.getValue());
    }

    public Contact getContact() {
        return this.cls_Contact;
    }

    public void setContact(Contact contact) {
        this.cls_Contact = contact;
    }

    public String getXml() {
        return this.getXmlForSnapshot(null, null);
    }

    public String getXmlForSnapshot(NetworkItem networkItem, Profile profile) {
        String string = this.cls_LicenseKey;
        if (this.cls_IsLicensed && (string == null || string.length() == 0)) {
            string = Encode.encode(this.getInternalKeyData());
        }
        String string2 = "<network" + XmlUtil.createAttribute(ATTRIBUTE_SUBNETS, this.getSubnets().getList()) + XmlUtil.createAttribute(ATTRIBUTE_EXPIRATION, this.getExpirationDate()) + XmlUtil.createAttribute(ATTRIBUTE_VERSION, this.getVersion()) + XmlUtil.createAttribute(ATTRIBUTE_CONTRACT_STATE, this.getContractState(), 1) + XmlUtil.createAttribute(ATTRIBUTE_GUI_FLAGS, this.getGuiFlags(), 0L) + ">" + '\n';
        string2 = string2 + XmlUtil.createElement(ELEMENT_NAME, this.getName()) + XmlUtil.createElement(ELEMENT_WELCOME_TITLE, this.getWelcomeTitle()) + XmlUtil.createElement(ELEMENT_DESCRIPTION, this.getDescription()) + XmlUtil.createElement(ELEMENT_REFRESH_URL, this.getRefreshUrl()) + XmlUtil.createElement(ELEMENT_LICENSEE, this.getLicensee()) + XmlUtil.createElement(ELEMENT_LICENSE, string) + XmlUtil.createElement(ELEMENT_SERVER_ADDRESS, this.getServerAddress()) + XmlUtil.createElement(ELEMENT_UNSUPPORTED_OS_MESSAGE, this.getUnsupportedOsMessage()) + XmlUtil.createElement(ELEMENT_UNSUPPORTED_OS_URL, this.getUnsupportedOsUrl());
        string2 = string2 + this.getContact().getXml(true);
        string2 = string2 + XmlUtil.createElementOpen(ELEMENT_NETWORK_ITEMS);
        if (networkItem == null) {
            for (int i = 0; i < this.cls_NetworkItems.size(); ++i) {
                string2 = string2 + this.cls_NetworkItems.elementAt(i).getXml();
            }
        } else {
            string2 = string2 + networkItem.getXmlForSnapshot(profile);
        }
        string2 = string2 + XmlUtil.createElementClose(ELEMENT_NETWORK_ITEMS);
        string2 = string2 + this.cls_Options.getXml();
        string2 = string2 + XmlUtil.createElementClose(ELEMENT_NETWORK);
        return string2;
    }

    public String toString() {
        return "[Network name=\"" + this.getName() + "\"]";
    }

    private String getInternalKeyData() {
        return "!(&Dh8*" + this.cls_Name + ":" + this.cls_Licensee + "Tx1<" + this.cls_ExpirationDate;
    }

    public String getBaseUrl() {
        String string = this.getRefreshUrl();
        if (string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(47);
        if (n <= 8) {
            return "";
        }
        return string.substring(0, n);
    }

    public boolean getGuiFlag_HideOptions() {
        return (this.getGuiFlags() & 1L) > 0L;
    }

    public NetworkItem getNextNetworkItem(String string) {
        log.debug((Object)("Will get next network_item after '" + string + "'."));
        if (string != null) {
            for (int i = 0; i < this.cls_NetworkItems.size(); ++i) {
                if (!string.equals(this.cls_NetworkItems.elementAt(i).getName())) continue;
                log.debug((Object)(" - Found network_item at index " + i + "."));
                if (i + 1 >= this.cls_NetworkItems.size()) continue;
                return this.cls_NetworkItems.elementAt(i + 1);
            }
        }
        log.debug((Object)("Could not locate next network_item after " + string + "."));
        return null;
    }

    public static Network getInstance() {
        return new Network();
    }

    public static Network getInstance(String string) {
        Network network = new Network();
        network.setName(string);
        return network;
    }
}

