/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.mac.common;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import org.apache.log4j.Logger;

public class MacPskBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(MacPskBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.MAC_SSID, Settings.SettingId.MAC_SSID_PSK};
    private boolean cls_IsPsk = false;

    public MacPskBuffer() {
        super(INTERESTED_SETTINGS);
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        if (this.cls_IsPsk) {
            SettingValue settingValue = new SettingValue();
            Settings.SettingId settingId = setting.getSettingId();
            log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
            if (settingId == Settings.SettingId.MAC_SSID) {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            } else if (settingId == Settings.SettingId.MAC_SSID_PSK) {
                settingValue.setValue("1");
                settingValue.setAdditionalValue(setting.getAdditionalValue());
            }
            log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
            return settingValue;
        }
        return null;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        log.info((Object)"Will refresh.");
        boolean bl = false;
        String string = "";
        String string2 = "";
        for (int i = 0; i < settingArray.length; ++i) {
            if (Settings.SettingId.MAC_SSID.equals((Object)settingArray[i].getSettingId())) {
                string = settingArray[i].getAdditionalValue();
                log.info((Object)("Desired ssid name for psk determined to be '" + string + "'."));
                continue;
            }
            if (!Settings.SettingId.MAC_SSID_PSK.equals((Object)settingArray[i].getSettingId())) continue;
            log.info((Object)"The profile is psk-based.");
            bl = true;
            string2 = settingArray[i].getAdditionalValue();
        }
        this.cls_IsPsk = bl;
        if (bl) {
            log.info((Object)"Will banish the pre-shared key from the log.");
            BanishedWords.add(string2, "[PRE-SHARED KEY]");
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, Boolean.TRUE);
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, string2);
        } else {
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, Boolean.FALSE);
            selectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, null);
        }
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }
}

