/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.os.common;

import com.cloudpath.assess.buffer.AbstractBuffer;
import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileBuffer
extends AbstractBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(FileBuffer.class);
    private static final Settings.SettingId[] INTERESTED_SETTINGS = new Settings.SettingId[]{Settings.SettingId.FILE_CONTENT};
    private final FileHandler cls_FileHandler;

    public FileBuffer(FileHandler fileHandler) {
        super(INTERESTED_SETTINGS);
        this.cls_FileHandler = fileHandler;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)(this.getClass().getSimpleName() + " will set value for " + (Object)((Object)settingId) + " to " + settingValue.getValue() + "/" + settingValue.getAdditionalValue()));
        if (settingId == Settings.SettingId.FILE_CONTENT) {
            File file = this.getFile(settingValue.getUnenforcedValue());
            try {
                this.cls_FileHandler.writeFile(file, settingValue.getAdditionalValue());
                log.debug((Object)("Wrote file: " + file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                log.warn((Object)("Error occurred while writing file " + settingValue.getUnenforcedValue() + "."), (Throwable)iOException);
            }
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        SettingValue settingValue = new SettingValue();
        Settings.SettingId settingId = setting.getSettingId();
        log.info((Object)("Will read value for " + (Object)((Object)settingId) + "."));
        if (settingId == Settings.SettingId.FILE_CONTENT) {
            settingValue.setUnenforcedValue(setting.getUnenforcedValue());
            settingValue.setValue(setting.getValue());
            File file = this.getFile(setting.getUnenforcedValue());
            try {
                settingValue.setAdditionalValue(this.cls_FileHandler.readFile(file));
                log.debug((Object)("Read file: " + file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                log.warn((Object)("Error occurred while reading file " + setting.getUnenforcedValue() + "."), (Throwable)iOException);
            }
        }
        log.info((Object)("Read value for " + (Object)((Object)settingId) + " as '" + settingValue.getValue() + "' and '" + settingValue.getAdditionalValue() + "'."));
        return settingValue;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
    }

    public void commit(SelectionHandler selectionHandler) throws Exception {
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private File getFile(String string) {
        File file;
        if (string.startsWith("${user.home}")) {
            string = Util.replaceVariable(string, "user.home", "");
            file = new File(System.getProperty("user.home"), string);
        } else if (string.startsWith("${root}")) {
            string = Util.replaceVariable(string, "root", "");
            file = new File(File.listRoots()[0], string);
        } else {
            file = new File(string);
        }
        return file;
    }
}

