/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.buffer;

import com.cloudpath.assess.buffer.Buffer;
import com.cloudpath.assess.buffer.BufferManager;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.SpecializedException;
import com.cloudpath.common.util.Util;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BufferManagerImpl
implements BufferManager,
Buffer {
    private static final Logger log = Logger.getLogger(BufferManagerImpl.class);
    private final Buffer[] cls_Buffers;
    private final Vector<Setting> cls_ModifiedSettings = new Vector();

    public BufferManagerImpl(Buffer[] bufferArray) {
        this.cls_Buffers = bufferArray;
    }

    public boolean setSystemValue(Setting setting, SettingValue settingValue) throws InvalidValueException {
        log.warn((Object)("CONFIGURATION: Setting " + setting.getRuntime().getDisplayText() + " to " + settingValue));
        this.cls_ModifiedSettings.add(setting);
        Setting[] settingArray = new Setting[]{setting};
        for (int i = 0; i < this.cls_Buffers.length; ++i) {
            if (!this.cls_Buffers[i].isIncluded(settingArray)) continue;
            this.cls_Buffers[i].setSystemValue(setting, settingValue);
        }
        return true;
    }

    public SettingValue getSystemValue(Setting setting, boolean bl) {
        log.debug((Object)(Util.getClassName(this) + " will get system value for " + (Object)((Object)setting.getSettingId())));
        Setting[] settingArray = new Setting[]{setting};
        for (int i = 0; i < this.cls_Buffers.length; ++i) {
            if (!this.cls_Buffers[i].isIncluded(settingArray)) continue;
            log.debug((Object)(" - Will query value from " + Util.getClassName(this.cls_Buffers[i])));
            SettingValue settingValue = this.cls_Buffers[i].getSystemValue(setting, bl);
            if (settingValue == null) continue;
            return settingValue;
        }
        System.err.println("\n\n\n* * * * NO BUFFER CONFIGURED FOR " + (setting != null ? setting.getSettingId() : "") + " * * * *\n\n\n");
        log.error((Object)("NO BUFFER CONFIGURED FOR " + (setting != null ? setting.getSettingId() : "")));
        return null;
    }

    public void refresh(SelectionHandler selectionHandler, Setting[] settingArray) {
        int n;
        String string = "";
        for (n = 0; settingArray != null && n < settingArray.length; ++n) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + (settingArray[n] != null ? settingArray[n].getSettingId() : "NULL");
        }
        log.debug((Object)(Util.getClassName(this) + " will refresh " + settingArray.length + " settings. (" + string + ")"));
        for (n = 0; n < this.cls_Buffers.length; ++n) {
            log.debug((Object)("  - Looking at " + Util.getClassName(this.cls_Buffers[n])));
            if (!this.cls_Buffers[n].isIncluded(settingArray)) continue;
            log.debug((Object)"    - Will tell to refresh.");
            this.cls_Buffers[n].refresh(selectionHandler, settingArray);
        }
        this.cls_ModifiedSettings.clear();
    }

    public void commit(SelectionHandler selectionHandler) throws SpecializedException {
        log.debug((Object)"Buffer Manager will commit changes...");
        Setting[] settingArray = new Setting[this.cls_ModifiedSettings.size()];
        this.cls_ModifiedSettings.toArray(settingArray);
        for (int i = 0; i < this.cls_Buffers.length; ++i) {
            if (!this.cls_Buffers[i].isIncluded(settingArray)) continue;
            log.debug((Object)("  - Buffer " + this.cls_Buffers[i] + " will be committed."));
            try {
                this.cls_Buffers[i].commit(selectionHandler);
                continue;
            }
            catch (SpecializedException specializedException) {
                log.error((Object)"BufferManager caught a specializedException.  Will send upward.", (Throwable)specializedException);
                throw specializedException;
            }
            catch (Exception exception) {
                log.error((Object)("An error occurred while committing buffer " + this.cls_Buffers[i] + "."), (Throwable)exception);
            }
        }
        this.cls_ModifiedSettings.clear();
    }

    public boolean isIncluded(Setting[] settingArray) {
        for (int i = 0; i < this.cls_Buffers.length; ++i) {
            if (!this.cls_Buffers[i].isIncluded(settingArray)) continue;
            return true;
        }
        return false;
    }
}

