/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess;

import com.cloudpath.assess.buffer.BufferManager;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Section;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.assess.util.Modifications;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.SpecializedException;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.awt.Color;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SectionController {
    private static final Logger log = Logger.getLogger(SectionController.class);
    private final BufferManager cls_BufferManager;
    private final SelectionHandler cls_SelectionHandler;
    private final boolean cls_ForRevert;
    private int cls_CurrentSectionIndex = 0;
    private boolean cls_IsFirstRun = true;

    public SectionController(SelectionHandler selectionHandler, BufferManager bufferManager, Profile profile, boolean bl) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_BufferManager = bufferManager;
        this.cls_ForRevert = bl;
    }

    public boolean isForRevert() {
        return this.cls_ForRevert;
    }

    public void init() {
        Setting setting;
        int n;
        Section section;
        int n2;
        log.info((Object)"SectionController.init()");
        Profile profile = this.getProfile();
        for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
            this.refreshSection(n2, "initialize");
        }
        log.debug((Object)("SectionController for revert? " + this.cls_ForRevert));
        if (this.cls_ForRevert) {
            this.cls_CurrentSectionIndex = profile.getSectionCount() - 1;
            log.debug((Object)("For revert, will start at section " + this.cls_CurrentSectionIndex));
            log.debug((Object)"Will copy originals to required...");
            for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
                section = profile.getSection(n2);
                for (n = 0; n < section.getSettingCount(); ++n) {
                    setting = section.getSetting(n);
                    setting.setRequiredValue(setting.getRuntime().getOriginalValue().clone());
                    String string = setting.getLabelWhenIncorrect();
                    setting.setLabelWhenIncorrect(setting.getLabelWhenRepaired());
                    setting.setLabelWhenRepaired(string);
                    setting.setIsRequired(false);
                }
            }
        }
        log.debug((Object)"Will copy current to originals...");
        for (n2 = 0; n2 < profile.getSectionCount(); ++n2) {
            section = profile.getSection(n2);
            for (n = 0; n < section.getSettingCount(); ++n) {
                setting = section.getSetting(n);
                if (setting.getRuntime().getIsOriginalValueOverridden()) continue;
                setting.getRuntime().setOriginalValue(setting.getRuntime().getCurrentValue().clone());
            }
        }
    }

    public Setting[] process(boolean bl, Setting[] settingArray) throws SpecializedException {
        Setting[] settingArray2;
        log.info((Object)("SectionController will process section " + this.cls_CurrentSectionIndex + " with autoFix " + bl));
        if (bl) {
            try {
                log.debug((Object)("Requesting that section " + this.cls_CurrentSectionIndex + " be auto fixed."));
                this.fixSection(this.cls_CurrentSectionIndex, settingArray);
            }
            catch (InvalidValueException invalidValueException) {
                log.error((Object)("Error occurred fixing setting in section " + this.cls_CurrentSectionIndex + "."), (Throwable)invalidValueException);
            }
        }
        if (!this.cls_IsFirstRun) {
            this.refreshSection(this.cls_CurrentSectionIndex, "process(" + bl + ")");
        }
        if (this.gotoIncorrectSection(!this.cls_IsFirstRun)) {
            settingArray2 = null;
        } else {
            settingArray2 = this.getIncorrectSettings(this.cls_CurrentSectionIndex);
            for (int i = 0; i < settingArray2.length; ++i) {
                settingArray2[i].getRuntime().incrementIncorrectNotificationCount();
            }
        }
        this.cls_IsFirstRun = false;
        return settingArray2;
    }

    public Modifications getModifications() {
        Profile profile = this.getProfile();
        Modifications modifications = new Modifications();
        for (int i = 0; i < profile.getSectionCount(); ++i) {
            Section section = profile.getSection(i);
            ArrayList<Setting> arrayList = new ArrayList<Setting>();
            for (int j = 0; j < section.getSettingCount(); ++j) {
                Setting setting = section.getSetting(j);
                if (setting.getRuntime().getIsOriginalValue()) continue;
                arrayList.add(setting);
            }
            Setting[] settingArray = new Setting[arrayList.size()];
            arrayList.toArray(settingArray);
            modifications.addSection(settingArray);
        }
        return modifications;
    }

    private boolean gotoIncorrectSection(boolean bl) {
        Profile profile = this.getProfile();
        if (profile == null || profile.getSectionCount() <= this.cls_CurrentSectionIndex) {
            return true;
        }
        if (this.isSectionAcceptable(this.cls_CurrentSectionIndex)) {
            log.debug((Object)("Section " + this.cls_CurrentSectionIndex + " is acceptable."));
            if (this.gotoNextSection(bl)) {
                return this.gotoIncorrectSection(bl);
            }
            return true;
        }
        return false;
    }

    private boolean gotoNextSection(boolean bl) {
        log.debug((Object)"Will move to next section.");
        this.cls_CurrentSectionIndex = this.cls_ForRevert ? --this.cls_CurrentSectionIndex : ++this.cls_CurrentSectionIndex;
        if (this.cls_CurrentSectionIndex < 0 || this.cls_CurrentSectionIndex >= this.getProfile().getSectionCount()) {
            return false;
        }
        if (bl) {
            this.refreshSection(this.cls_CurrentSectionIndex, "Move To Section " + this.cls_CurrentSectionIndex);
        }
        return true;
    }

    private void refreshSection(int n, String string) {
        log.info((Object)("Will refresh section " + n + " from " + string));
        log.info((Object)("Profile: " + this.getProfile()));
        if (this.getProfile() != null) {
            log.info((Object)("Section " + n + ": " + this.getProfile().getSection(n)));
            Setting[] settingArray = this.getProfile().getSection(n).getSettings();
            this.cls_BufferManager.refresh(this.cls_SelectionHandler, settingArray);
            for (int i = 0; i < settingArray.length; ++i) {
                SettingValue settingValue = this.cls_BufferManager.getSystemValue(settingArray[i], this.cls_ForRevert);
                settingArray[i].getRuntime().setCurrentValue(settingValue);
            }
        } else {
            log.info((Object)("Received request to refresh section " + n + " but profile is null."));
        }
    }

    private Setting[] getIncorrectSettings(int n) {
        Setting[] settingArray = this.getProfile().getSection(n).getSettings();
        ArrayList<Setting> arrayList = new ArrayList<Setting>();
        for (int i = 0; i < settingArray.length; ++i) {
            if (settingArray[i].getRuntime().isCurrentValueCorrect()) continue;
            arrayList.add(settingArray[i]);
        }
        Setting[] settingArray2 = new Setting[arrayList.size()];
        arrayList.toArray(settingArray2);
        return settingArray2;
    }

    private boolean isSectionAcceptable(int n) {
        Profile profile = this.getProfile();
        log.debug((Object)("Is section " + n + " acceptable in profile '" + profile.getName() + "'?"));
        Section section = profile.getSection(n);
        if (section == null) {
            log.error((Object)" -- Section is null.");
            throw new RuntimeException("Secton " + n + " is null. Most likely, the selected profile exists but does not contain any sections. " + profile.getSectionCount() + " - " + profile.getName());
        }
        Setting[] settingArray = profile.getSection(n).getSettings();
        log.debug((Object)(" -- Setting count: " + settingArray.length));
        for (int i = 0; i < settingArray.length; ++i) {
            log.debug((Object)(" -- Checking " + (Object)((Object)settingArray[i].getSettingId())));
            Color color = settingArray[i].getRuntime().getCurrentColor();
            if (!Color.RED.equals(color) && !Color.yellow.equals(color)) continue;
            return false;
        }
        return true;
    }

    private boolean fixSection(int n, Setting[] settingArray) throws InvalidValueException, SpecializedException {
        log.debug((Object)("Will fix section " + n));
        boolean bl = false;
        Setting[] settingArray2 = settingArray != null && settingArray.length > 0 ? settingArray : this.getProfile().getSection(n).getSettings();
        for (int i = 0; i < settingArray2.length; ++i) {
            if (!settingArray2[i].getCanAutoFix() || Color.green.equals(settingArray2[i].getRuntime().getCurrentColor())) continue;
            log.debug((Object)(" - Setting " + (Object)((Object)settingArray2[i].getSettingId()) + " is incorrect and supports auto fix.  Will set system value."));
            this.cls_BufferManager.setSystemValue(settingArray2[i], settingArray2[i].getRequiredValue());
            bl = true;
        }
        if (bl) {
            log.debug((Object)"Will commit the changes.");
            try {
                this.cls_BufferManager.commit(this.cls_SelectionHandler);
            }
            catch (SpecializedException specializedException) {
                throw specializedException;
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while committing buffer.", (Throwable)exception);
            }
        }
        return bl;
    }

    public String toString() {
        return Util.createToString(this.getClass());
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }
}

