/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.CustomSelection;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.dispatch.StepBackwardSelection;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.network.ifconfig.IpListener;
import com.cloudpath.common.os.mac.common.network.ifconfig.IpMonitor;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.UrlLoader;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.BlockUtil;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import java.net.URL;
import org.apache.log4j.Logger;

public class ValidateBlock
implements WorkflowBlock,
IpListener {
    private static final Logger log = Logger.getLogger(ValidateBlock.class);
    private static final int SELECTON_RENEW_IP = 10;
    private final SelectionHandler cls_SelectionHandler;
    private final OsProvider cls_OsProvider;
    private final AsyncHandler cls_AsyncHandler;
    private IpMonitor cls_IpMonitor;

    public ValidateBlock(SelectionHandler selectionHandler, OsProvider osProvider, AsyncHandler asyncHandler) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_OsProvider = osProvider;
        this.cls_AsyncHandler = asyncHandler;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_INTERFACE, WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME, WorkflowConstants.DataType.DESIRED_SSID_NAME};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return this.isTabEnabled() ? XpcConstants.VALIDATE : null;
    }

    public boolean reset() {
        log.info((Object)"Will reset ValidateBlock...");
        if (this.cls_IpMonitor != null) {
            log.info((Object)" - Will stop IP monitor.");
            this.cls_IpMonitor.stop();
        }
        return true;
    }

    public synchronized DispatchRequest doProcess(boolean bl) {
        Profile profile;
        String string;
        Object object;
        block39: {
            if (!this.isTabEnabled()) {
                log.warn((Object)(Util.getClassName(this) + " is not enabled."));
                return DoneRequest.INSTANCE;
            }
            if (bl) {
                log.debug((Object)("\n\n\nAt " + this.getClass().getSimpleName() + ": " + '\n' + this.cls_SelectionHandler.print() + "\n\n"));
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED, null);
                return DoneRequest.INSTANCE;
            }
            BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Validating Connectivity", "", "/loading.gif"));
            if (this.cls_IpMonitor != null) {
                log.debug((Object)"Stopping the previous ssid monitor.");
                this.cls_IpMonitor.stop();
            }
            boolean bl2 = false;
            if (this.getIpAddressReceived() == null) {
                int n = this.getNetworkItem().getDhcpWaitSeconds();
                if (n > 0) {
                    log.info((Object)("Will sleep " + n + " seconds for DHCP."));
                    try {
                        Thread.sleep(n * 1000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cls_OsProvider.renewIp(this.getInterface());
                }
                try {
                    this.cls_OsProvider.getNicProvider().refresh();
                    NetworkInterface networkInterface = this.cls_OsProvider.getNicProvider().getInterface(this.getInterface().getLogicalGuid());
                    log.debug((Object)("Updated nic: " + networkInterface.getName() + " -> " + networkInterface.getIpAddress()));
                    if (NetworkInterface.isValidIpAddress(networkInterface.getIpAddress()) && NetworkInterface.isIpAddressInSubnets(networkInterface.getIpAddress(), this.getDesiredSubnets())) {
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED, networkInterface.getIpAddress());
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
                        bl2 = true;
                        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest(null, "IP address " + networkInterface.getIpAddress() + " received.", "/loading.gif"));
                    }
                }
                catch (Exception exception) {
                    log.warn((Object)"An error occurred while trying to retrieve IP address.", (Throwable)exception);
                }
            } else {
                bl2 = true;
            }
            if (!bl2) {
                log.debug((Object)"Starting the IP monitor.");
                try {
                    this.cls_IpMonitor = new IpMonitor(this.getClass().getSimpleName(), this.cls_OsProvider.getNicProvider(), this.getInterface(), this.getDesiredSubnets(), this, 400, 50, 20000L, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new WaitRequest(null, "Waiting for a network address, which will allow the computer to participate on the network.  This may take a couple moments.", "", new SkipSelection("- IP address assignment was skipped prior to timeout."), null, null, "/loading.gif");
            }
            if (!this.isWired()) {
                try {
                    BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest(null, "Verifying that we are still connected to the wireless network \"" + this.getSsid() + "\".", null));
                    log.debug((Object)"Loading the current association.");
                    WirelessAssociation wirelessAssociation = this.cls_OsProvider.getWirelessProvider().getCurrentAssociation(this.getInterface().getLogicalGuid());
                    if (wirelessAssociation.isEnabled() && wirelessAssociation.isAssociatedTo(this.getSsid())) {
                        log.debug((Object)"Association is still correct.");
                        break block39;
                    }
                    for (int i = 0; i < 5 && wirelessAssociation.isEnabled() && !wirelessAssociation.isAssociatedTo(this.getSsid()); ++i) {
                        log.info((Object)("SSID check in IP validation block failed at attempt " + i + ".  Will retry."));
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        wirelessAssociation = this.cls_OsProvider.getWirelessProvider().getCurrentAssociation(this.getInterface().getLogicalGuid());
                    }
                    if (wirelessAssociation.isEnabled() && wirelessAssociation.isAssociatedTo(this.getSsid())) {
                        log.info((Object)"After further attempts, we are correctly associated.");
                        break block39;
                    }
                    log.error((Object)"We associated but while waiting for an IP we reassociated elsewhere.");
                    URL uRL = null;
                    try {
                        uRL = ValidateBlock.class.getResource("/airport.gif");
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Unable to find airport.gif", (Throwable)exception);
                    }
                    String string2 = uRL == null ? "" : "<img src='" + uRL + "'> ";
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, null);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED, null);
                    return new WaitRequest("Wireless Connection Lost", "Your computer is now configured for the wireless network, but the connection to \"" + this.getSsid() + "\" was lost.  You may click \"Retry\" below to attempt to associate again.  <br><br>Alternately, you may use the " + string2 + "wireless icon in the menu to select \"" + this.getSsid() + "\".", "", new SkipSelection("- Association to SSID was lost."), "Retry", new StepBackwardSelection(), "/error.gif");
                }
                catch (Exception exception) {
                    log.error((Object)"An error occurred while checking current association after getting an ip address.");
                    return new ErrorRequest(null, "Association to SSID lost.", true, true);
                }
            }
        }
        log.info((Object)"Will verify connectivity...");
        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest(null, "Verifying connectivity...", "/loading.gif"));
        String string3 = this.getNetworkItem().getValidationUrl();
        String string4 = this.getNetworkItem().getValidationGrep();
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_CONNECTION_VALIDATED, null);
        if (string3 != null && string3.length() > 0) {
            log.info((Object)("Validation url is '" + string3 + "'."));
            object = UrlLoader.getTextFileFromUrl(string3, 5000L);
            if (!((UrlLoader.UrlResponse)object).isSuccessful()) {
                log.debug((Object)"Initial response from validation URL a failure.");
                BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest(null, "Initial verification failed.  Will try longer test...", "/loading.gif"));
                object = UrlLoader.getTextFileFromUrl(string3, 20000L);
                if (!((UrlLoader.UrlResponse)object).isSuccessful()) {
                    log.debug((Object)"Second response from validation URL was also a failure.");
                    return new ErrorRequest(null, "We failed to validate that the network connection was functioning properly.  A response was not received from " + string3 + ".", true, true);
                }
                log.debug((Object)"Second response from validation URL was successful.");
            } else {
                log.debug((Object)"Initial response from validation URL was successful.");
            }
            if (string4 != null && string4.length() > 0) {
                log.info((Object)("Validation grep is '" + string4 + "'."));
                if (!((UrlLoader.UrlResponse)object).getOutput().contains(string4)) {
                    log.debug((Object)"Validation grep is not present.");
                    return new ErrorRequest(null, "We failed to validate that the network connection was functioning properly.  An incorrect response was received from " + string3 + ".", true, true);
                }
                log.debug((Object)"Validation grep is present.");
            }
        }
        log.info((Object)"Connection has been validated.");
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_CONNECTION_VALIDATED, Boolean.TRUE);
        object = this.getNetworkItem().getEndpointUrl();
        if (object != null && ((String)object).length() > 0) {
            object = XpcUtil.replaceVariables((String)object, this.cls_SelectionHandler);
            try {
                log.debug((Object)("Opening post-transition url '" + (String)object + "'."));
                this.cls_OsProvider.openBrowser((String)object);
            }
            catch (Exception exception) {
                log.warn((Object)("Failed to open browser to '" + (String)object + "'."), (Throwable)exception);
            }
        }
        if ((string = (profile = this.getProfile()).getPostTransitionScript()) != null && string.length() > 0) {
            log.info((Object)"Will run post transition script.");
            string = XpcUtil.replaceVariables(string, this.cls_SelectionHandler);
            try {
                this.cls_OsProvider.runScript(string, profile.getPostRunas() == 1);
            }
            catch (Exception exception) {
                log.error((Object)"Failed to run post transition script.", (Throwable)exception);
            }
        }
        BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest(null, "Preparing connection...", "/loading.gif"));
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DoneRequest.INSTANCE;
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            return this.doProcess(bl);
        }
        log.info((Object)("Selection is: " + dispatchResponse));
        if (dispatchResponse instanceof SkipSelection) {
            log.info((Object)"User has selected to skip validation.");
            if (this.cls_IpMonitor != null) {
                this.cls_IpMonitor.stop();
            }
            String string = ((SkipSelection)dispatchResponse).getMessage();
            String string2 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SKIP_MESSAGES);
            if (string2 == null) {
                string2 = "";
            } else if (string2.length() > 0) {
                string2 = string2 + "\n";
            }
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SKIP_MESSAGES, string2 + string);
            return DoneRequest.INSTANCE;
        }
        if (dispatchResponse instanceof RetrySelection) {
            log.info((Object)"User has selected to retry validation.");
            return this.doProcess(bl);
        }
        if (dispatchResponse instanceof CustomSelection && ((CustomSelection)dispatchResponse).getId() == 10) {
            this.cls_OsProvider.renewIp(this.getInterface());
            return this.doProcess(bl);
        }
        log.error((Object)("Unknown selection: " + dispatchResponse));
        return this.doProcess(bl);
    }

    private boolean isWired() {
        return this.getInterface().getInterfaceType() != 2;
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private NetworkInterface getInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }

    private String getSsid() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private String getIpAddressReceived() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED);
    }

    private String[] getDesiredSubnets() {
        return null;
    }

    private boolean getMigrationBehavior() {
        switch (this.getNetworkItem().getMigrationBehavior()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.cls_OsProvider.getWirelessProvider().ssidIsInScanList(this.getInterface().getName(), this.getSsid());
            }
        }
        return true;
    }

    private boolean isTabEnabled() {
        if (this.getNetworkItem() != null && this.getProfile() != null) {
            return this.getMigrationBehavior();
        }
        return false;
    }

    public void ipReceived(String string) {
        log.info((Object)("Received notification that we received ip " + string + "."));
        DispatchRequest dispatchRequest = this.doProcess(false);
        BlockUtil.sendAsync(this.cls_AsyncHandler, dispatchRequest);
    }

    public void ipRemoved() {
    }

    public void timeoutOccurred() {
        log.info((Object)("Timed out while waiting for ip address on interface '" + this.getInterface().getName() + "'."));
        WaitRequest waitRequest = new WaitRequest(null, Resources.ResourceString.ERROR_FAILED_IP.getValue(), "Skip", new SkipSelection("- IP address assignment was skipped."), "Retry", new CustomSelection(10), "/error.gif");
        BlockUtil.sendAsync(this.cls_AsyncHandler, waitRequest);
    }
}

