/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.CredentialBlock;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.cert.IssuedCertificate;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.leopard.cert.CertificateLoader;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.BlockUtil;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class TlsBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(CredentialBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final Maccmd cls_Maccmd;
    private final AsyncHandler cls_AsyncHandler;

    public TlsBlock(SelectionHandler selectionHandler, OsProvider osProvider, Maccmd maccmd, CommandHandler commandHandler, AsyncHandler asyncHandler) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_Maccmd = maccmd;
        this.cls_AsyncHandler = asyncHandler;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_PROFILE};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return this.getProfile() != null ? XpcConstants.CONFIGURE : null;
    }

    public boolean reset() {
        return true;
    }

    public synchronized DispatchRequest doProcess(boolean bl) {
        if (bl) {
            log.debug((Object)"Done due to revert.");
            return new DoneRequest("TlsBlockRevert");
        }
        log.debug((Object)"Will check for client certificate setting...");
        Profile profile = this.getProfile();
        Setting setting = profile.getSettingById(Settings.SettingId.CERTIFICATE_CLIENT);
        if (setting != null) {
            log.debug((Object)"Client certificate setting found.");
            BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Loading Certificate...", "We are processing the authentication and loading the certificate...", "/loading.gif"));
            try {
                String string;
                String string2 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME);
                log.debug((Object)("Dot1x Profile Name: " + string2));
                boolean bl2 = string2 != null && LeopardEapProfile.isSystemProfile(string2);
                log.debug((Object)("System Profile: " + bl2));
                IssuedCertificate issuedCertificate = (IssuedCertificate)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_ISSUED_CERTIFICATE);
                log.debug((Object)("Issued Cert: " + issuedCertificate));
                CertificateLoader.CertificateResponse certificateResponse = null;
                if (OsConstants.isMacSnowLeopardOrBefore()) {
                    certificateResponse = CertificateLoader.saveClientCertificate(this.cls_Maccmd, issuedCertificate, bl2);
                    log.debug((Object)("Cert Response: " + certificateResponse));
                } else {
                    log.debug((Object)"Will not attempt to get certificate response vis save() due to OS version.");
                }
                Credential credential = (Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
                if (certificateResponse != null) {
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_CERTIFICATE_RESPONSE, certificateResponse);
                    string = certificateResponse.getCommonName();
                    String string3 = certificateResponse.getEmailAddress();
                    try {
                        log.debug((Object)"Will find identity handle.");
                        String string4 = this.cls_Maccmd.getIdentityHandle(string, string3);
                        log.info((Object)("Identity handle is: " + string4));
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_IDENTITY_HANDLE, string4);
                    }
                    catch (Exception exception) {
                        log.error((Object)"Unable to determine identity handle.", (Throwable)exception);
                    }
                }
                if (OsConstants.isMacSnowLeopardOrLater() && certificateResponse != null && string2 != null) {
                    if (bl2) {
                        string = this.getInterface().getServiceName();
                        log.debug((Object)("Will set TLS identity for system profile on '" + string + "'."));
                        this.cls_Maccmd.setTlsIdentityOnSystemProfile(string, certificateResponse);
                    } else {
                        log.debug((Object)("Will set TLS identity for user profile '" + string2 + "'."));
                        this.cls_Maccmd.setTlsIdentityOnUserProfile(string2, certificateResponse);
                    }
                }
                return new DoneRequest("TlsBlockB");
            }
            catch (CertificateLoader.CertificateGenerationException certificateGenerationException) {
                log.error((Object)"Failed to retrieve certificate.", (Throwable)certificateGenerationException);
                return new ErrorRequest(null, "Failed to load certificate.<br><br>" + certificateGenerationException.getBasicMessage() + "<br><br>(Error: " + (Object)((Object)certificateGenerationException.getErrorCode()) + ")", false, true);
            }
        }
        return new DoneRequest("TlsBlockC");
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        return this.doProcess(bl);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private NetworkInterface getInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }
}

