/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.SnapshotUtil;
import com.cloudpath.app.xpc.workflow.block.request.AssociateToSsidRequest;
import com.cloudpath.app.xpc.workflow.block.request.EnableAirportRequest;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.CustomSelection;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.network.airport.AirportListener;
import com.cloudpath.common.os.mac.common.network.airport.AirportMonitor;
import com.cloudpath.common.os.mac.common.network.airport.SsidListener;
import com.cloudpath.common.os.mac.common.network.airport.SsidMonitor;
import com.cloudpath.common.os.mac.common.network.ifconfig.IpListener;
import com.cloudpath.common.os.mac.common.network.ifconfig.IpMonitor;
import com.cloudpath.common.os.mac.tiger.network.airport.TigerAirportReader;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class TigerReconnectBlock
implements WorkflowBlock,
SsidListener,
IpListener,
AirportListener {
    private static final Logger log = Logger.getLogger(TigerReconnectBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final NicProvider cls_NicProvider;
    private final PersistenceHelper cls_Persistence;
    private final TigerAirportReader cls_WirelessProvider;
    private final AsyncHandler cls_AsyncHandler;
    private SsidMonitor cls_SsidMonitor;
    private IpMonitor cls_IpMonitor;
    private AirportMonitor cls_AirportMonitor;
    private boolean cls_FirstConnect = true;
    private String cls_WiredOriginalIp = "";
    private String cls_WiredNewIp = "";
    private boolean cls_WiredIpReceived = false;
    private boolean cls_WiredIpChanged = false;
    private boolean cls_WiredIpRemoved = false;

    public TigerReconnectBlock(SelectionHandler selectionHandler, NicProvider nicProvider, TigerAirportReader tigerAirportReader, AsyncHandler asyncHandler, PersistenceHelper persistenceHelper) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_NicProvider = nicProvider;
        this.cls_WirelessProvider = tigerAirportReader;
        this.cls_AsyncHandler = asyncHandler;
        this.cls_Persistence = persistenceHelper;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_INTERFACE, WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME, WorkflowConstants.DataType.DESIRED_SSID_NAME};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return this.isTabEnabled() ? XpcConstants.AUTHENTICATE : null;
    }

    public boolean reset() {
        if (this.isTabEnabled()) {
            this.cls_FirstConnect = true;
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, null);
            if (this.cls_SsidMonitor != null) {
                this.cls_SsidMonitor.stop();
            }
            if (this.cls_IpMonitor != null) {
                this.cls_IpMonitor.stop();
            }
            if (this.cls_AirportMonitor != null) {
                this.cls_AirportMonitor.stop(false);
            }
        }
        return true;
    }

    public synchronized DispatchRequest doProcess(boolean bl) {
        return this.doProcess(bl, false);
    }

    private synchronized DispatchRequest doProcess(boolean bl, boolean bl2) {
        if (!this.isTabEnabled()) {
            log.warn((Object)(Util.getClassName(this) + " is not enabled."));
            return DoneRequest.INSTANCE;
        }
        log.debug((Object)"------- STARTING RECONNECT DO PROCESS ---------");
        if (bl) {
            log.debug((Object)("\n\n\nAt " + this.getClass().getSimpleName() + ": " + '\n' + this.cls_SelectionHandler.print() + "\n\n"));
            log.warn((Object)(this.getClass().getSimpleName() + " is in revert mode, returning done."));
            if (!this.isWired()) {
                WirelessAssociation wirelessAssociation = null;
                try {
                    wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.getInterface().getLogicalGuid());
                    if (wirelessAssociation.isAssociatedTo(this.getSsid())) {
                        log.info((Object)"We are attahed to the desired ssid.  Will disconnect from ssid since we are reverting.");
                        this.cls_WirelessProvider.disconnect(this.getInterface().getLogicalGuid());
                    } else {
                        this.cls_WirelessProvider.abandon();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ORIGINAL_SSID);
                if (string != null && string.length() > 0) {
                    log.debug((Object)("Original ssid: " + string + " Current Ssid: " + wirelessAssociation.getSsid()));
                    if (wirelessAssociation == null || !wirelessAssociation.isAssociatedTo(string)) {
                        log.info((Object)("Will attempt to associate to the original ssid " + string));
                        this.cls_WirelessProvider.connect(this.getInterface().getLogicalGuid(), string, WirelessProvider.WirelessType.OPEN, "");
                    }
                }
            }
            return DoneRequest.INSTANCE;
        }
        if (this.cls_SsidMonitor != null) {
            log.debug((Object)"Stopping the previous ssid monitor.");
            this.cls_SsidMonitor.stop();
        }
        if (this.cls_IpMonitor != null) {
            log.debug((Object)"Stopping the previous ip monitor.");
            this.cls_IpMonitor.stop();
        }
        if (this.cls_AirportMonitor != null) {
            log.debug((Object)"Stopping the previous airport monitor.");
            this.cls_AirportMonitor.stop(true);
        }
        if (this.isWired()) {
            log.debug((Object)"Starting the ip monitor.");
            this.cls_NicProvider.refresh();
            this.cls_WiredOriginalIp = "";
            this.cls_WiredNewIp = "";
            this.cls_WiredIpReceived = false;
            this.cls_WiredIpChanged = false;
            this.cls_WiredIpRemoved = false;
            try {
                NetworkInterface networkInterface = this.cls_NicProvider.getInterface(this.getInterface().getLogicalGuid());
                if (NetworkInterface.isValidIpAddress(networkInterface.getIpAddress())) {
                    this.cls_WiredOriginalIp = networkInterface.getIpAddress();
                }
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while determining the original wired ip address.  Will assume blank.", (Throwable)exception);
            }
            this.cls_WirelessProvider.connect(this.getInterface().getLogicalGuid(), this.getProfileName(), WirelessProvider.WirelessType.DOT1X, "");
            this.cls_IpMonitor = new IpMonitor(this.getClass().getSimpleName(), this.cls_NicProvider, this.getInterface(), new String[0], this, 1000, 50, 3600000L, true);
        } else {
            block31: {
                try {
                    log.debug((Object)("Loading the current association for '" + this.getInterface().getLogicalGuid() + "'."));
                    WirelessAssociation wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.getInterface().getLogicalGuid());
                    if (!wirelessAssociation.isEnabled()) {
                        log.debug((Object)"Airport is turned off.  Ask the user to turn it on.  Will also start the monitor.");
                        this.cls_AirportMonitor = new AirportMonitor(this.cls_WirelessProvider, this.getInterface().getLogicalGuid(), true, this, 200, 10, 600000L);
                        return new EnableAirportRequest();
                    }
                    log.debug((Object)("Current ssid: " + wirelessAssociation.getSsid()));
                    if (wirelessAssociation.isAssociatedTo(this.getSsid())) {
                        if (this.cls_FirstConnect) {
                            log.info((Object)"User was already associated to the ssid.  Will force a disconnect.");
                            this.cls_WirelessProvider.disconnect(this.getInterface().getLogicalGuid());
                            Thread.sleep(200L);
                            break block31;
                        }
                        log.warn((Object)("Association to " + wirelessAssociation.getSsid() + " succeeded."));
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, Boolean.TRUE);
                        try {
                            this.cls_WirelessProvider.associationComplete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return DoneRequest.INSTANCE;
                    }
                    if (this.cls_FirstConnect && wirelessAssociation.isAssociated()) {
                        log.debug((Object)("Will set original association to '" + wirelessAssociation.getSsid() + "' and disconnect."));
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, wirelessAssociation.getSsid());
                        SnapshotUtil.captureSnapshot(this.cls_Persistence, this.cls_SelectionHandler, "before migration.");
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"An error occurred while checking current association.");
                }
            }
            if (bl2) {
                log.debug((Object)"* We believed we were associated, but we aren't yet.  May be waiting for cert acceptance.");
            } else {
                String string;
                this.cls_FirstConnect = false;
                boolean bl3 = this.isPsk();
                String string2 = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_PSK);
                String string3 = string = bl3 ? this.getSsid() : this.getProfileName();
                if (bl3) {
                    try {
                        this.cls_WirelessProvider.disconnect(this.getInterface().getLogicalGuid());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.cls_WirelessProvider.connect(this.getInterface().getLogicalGuid(), string, bl3 ? WirelessProvider.WirelessType.PSK : WirelessProvider.WirelessType.DOT1X, string2);
                log.debug((Object)"Informing GUI that we are waiting for association.");
            }
            log.debug((Object)"Starting the ssid monitor.");
            this.cls_SsidMonitor = new SsidMonitor(this.cls_WirelessProvider, this.getInterface().getLogicalGuid(), this.getSsid(), this, 1000, 50, 3600000L);
        }
        if (this.isPsk()) {
            return new WaitRequest("Associating to Wireless Network", "Please wait while we associate to the wireless network.", "/loading.gif");
        }
        return new AssociateToSsidRequest(this.getInterface().getLogicalGuid(), this.getProfileName(), this.getSsid(), true, this.getNetworkItem(), (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ORIGINAL_SSID));
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            return this.doProcess(bl);
        }
        log.info((Object)("Selection is: " + dispatchResponse));
        if (dispatchResponse instanceof SkipSelection) {
            log.info((Object)"User has selected to skip ssid association.");
            if (this.cls_SsidMonitor != null) {
                this.cls_SsidMonitor.stop();
            }
            return DoneRequest.INSTANCE;
        }
        if (dispatchResponse instanceof RetrySelection) {
            log.info((Object)"User has selected to retry association.");
            try {
                this.cls_WirelessProvider.disconnect(this.getInterface().getLogicalGuid());
            }
            catch (Exception exception) {
                log.info((Object)"Error while retrying association.", (Throwable)exception);
            }
            return this.doProcess(bl);
        }
        if (dispatchResponse instanceof CustomSelection) {
            CustomSelection customSelection = (CustomSelection)dispatchResponse;
            if (customSelection.getId() == 1200) {
                return this.doProcess(bl);
            }
            log.error((Object)("Unknown selection: " + dispatchResponse + " -> " + customSelection.getId()));
            return this.doProcess(bl);
        }
        log.error((Object)("Unknown selection: " + dispatchResponse));
        return this.doProcess(bl);
    }

    private boolean isWired() {
        return this.getInterface().getInterfaceType() != 2;
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private NetworkInterface getInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private String getProfileName() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME);
    }

    private String getSsid() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
    }

    public void associated(String string) {
        log.info((Object)("Received notification that we are associated to ssid " + string + "."));
        DispatchRequest dispatchRequest = this.doProcess(false, true);
        if (!(dispatchRequest instanceof AssociateToSsidRequest)) {
            log.info((Object)("Association monitor will return " + dispatchRequest));
            this.cls_AsyncHandler.processAsync(dispatchRequest);
        }
    }

    public void associationTimedout() {
    }

    public void associationPending(int n) {
    }

    public void ipReceived(String string) {
        log.debug((Object)("Notified that ip recieved was " + string));
        this.cls_WiredIpReceived = true;
        this.cls_WiredNewIp = string;
        if (!this.cls_WiredOriginalIp.equals(string)) {
            log.debug((Object)("Ip was actual change from " + this.cls_WiredOriginalIp + "."));
            this.cls_WiredIpChanged = true;
        }
        this.verifyWired();
    }

    public void ipRemoved() {
        log.debug((Object)"Ip was removed.");
        this.cls_WiredIpRemoved = true;
        this.verifyWired();
    }

    public void timeoutOccurred() {
    }

    private void verifyWired() {
        log.debug((Object)("Verifying wired: " + this.cls_WiredIpReceived + ", " + this.cls_WiredIpChanged + ", " + this.cls_WiredIpRemoved));
        if (this.cls_WiredIpChanged || this.cls_WiredIpReceived && this.cls_WiredIpRemoved) {
            this.cls_IpMonitor.stop();
            log.info((Object)("User has authenticated via wired (" + this.cls_WiredOriginalIp + " -> " + this.cls_WiredNewIp + ")."));
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED, Boolean.TRUE);
            try {
                this.cls_WirelessProvider.associationComplete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)("Will send async: " + DoneRequest.INSTANCE));
            this.cls_AsyncHandler.processAsync(DoneRequest.INSTANCE);
        } else {
            log.debug((Object)"Not yet verified.");
        }
    }

    public void airportStateChanged(boolean bl) {
        log.debug((Object)("Notified that airport state changed to " + bl));
        DispatchRequest dispatchRequest = this.doProcess(false);
        if (!(dispatchRequest instanceof EnableAirportRequest)) {
            log.debug((Object)("Due to airport state change, will send request: " + dispatchRequest));
            this.cls_AsyncHandler.processAsync(dispatchRequest);
        }
    }

    private boolean isPsk() {
        Boolean bl = (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK);
        boolean bl2 = bl != null && Boolean.TRUE.equals(bl);
        log.debug((Object)("Is Psk? " + bl2));
        return bl2;
    }

    private boolean getMigrationBehavior() {
        switch (this.getNetworkItem().getMigrationBehavior()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.cls_WirelessProvider.ssidIsInScanList(this.getInterface().getName(), this.getSsid());
            }
        }
        return true;
    }

    public boolean isTabEnabled() {
        if (this.getNetworkItem() != null && this.getProfile() != null) {
            return this.getMigrationBehavior();
        }
        return false;
    }
}

