/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.Md5;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.report.client.ReportHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import com.cloudpath.workflow.common.block.selection.ContinueSelection;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.log4j.Logger;

public class PrepareProfileBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(PrepareProfileBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final OsProvider cls_OsProvider;

    public PrepareProfileBlock(SelectionHandler selectionHandler, OsProvider osProvider) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_OsProvider = osProvider;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_PROFILE};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        return false;
    }

    public DispatchRequest doProcess(boolean bl) {
        block24: {
            Object object;
            String string;
            String string2;
            Object object2;
            Object object3;
            Object object4;
            if (bl) {
                log.info((Object)"PrepareProfileBlock will skip doProcess since we are reverting.");
                return new DoneRequest("PrepareProfileBlockRevert");
            }
            log.info((Object)"PrepareProfileBlock will run doProcess for non-revert.");
            log.info((Object)"Will check NIC.");
            NetworkInterface networkInterface = (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
            if (networkInterface != null && networkInterface.getInterfaceType() == 2) {
                log.info((Object)"NIC is a wireless nic.  Will check current association.");
                try {
                    object4 = this.cls_OsProvider.getWirelessProvider().getCurrentAssociation(networkInterface.getLogicalGuid());
                    if (object4 != null && object4.isAssociated()) {
                        log.debug((Object)("Original ssid is " + object4.getSsid()));
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ORIGINAL_SSID, object4.getSsid());
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"Unable to determine original ssid.", (Throwable)exception);
                }
            } else {
                log.info((Object)"NIC is not a wireless nic.");
            }
            log.info((Object)"Will check default credentials.");
            object4 = (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
            if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL) != null) {
                log.info((Object)"Credentials have been previously selected.");
            } else {
                log.info((Object)"Credentials have not been previously selected.");
                if (((NetworkItem)object4).getDefaultUserName().length() > 0 || ((NetworkItem)object4).getDefaultPassword().length() > 0) {
                    log.debug((Object)"Default credentials exist.  Will populate.");
                    object3 = ((NetworkItem)object4).getDefaultUserName();
                    object2 = ((NetworkItem)object4).getDefaultPassword();
                    string2 = "";
                    if (networkInterface != null && networkInterface.getMacAddress() != null) {
                        string2 = networkInterface.getMacAddress().toUpperCase().replace(":", "");
                    }
                    string = "";
                    try {
                        string = InetAddress.getLocalHost().getHostName();
                        if (string.endsWith(".local")) {
                            string = string.substring(0, string.length() - 6);
                        }
                    }
                    catch (Exception exception) {
                        log.error((Object)"Unable to determine host name.", (Throwable)exception);
                    }
                    object3 = ((String)object3).replace("${MAC_ADDRESS}", string2);
                    object3 = ((String)object3).replace("${COMPUTER_NAME}", string);
                    object2 = ((String)object2).replace("${MAC_ADDRESS}", string2);
                    object2 = ((String)object2).replace("${COMPUTER_NAME}", string);
                    if (object2 != null && ((String)object2).length() > 0) {
                        BanishedWords.add((String)object2, "[password]");
                    }
                    log.debug((Object)("User name is '" + (String)object3 + "'"));
                    log.debug((Object)("Computer name is '" + string + "'"));
                    object = new Credential();
                    ((Credential)object).setUserName((String)object3);
                    ((Credential)object).setPassword((String)object2);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, object);
                }
            }
            object3 = (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
            if (((NetworkItem)object3).getMessage().length() > 0) {
                log.info((Object)"NetworkItem contains a startup message.  Will show.");
                return new WaitRequest("Network Information", GuiConstants.createMessage(((NetworkItem)object3).getMessage()), null, null, "Continue", new ContinueSelection(), "/info.gif");
            }
            log.info((Object)"NetworkItem does not contain a startup message.");
            log.info((Object)"Will check if remote uploading is enabled for hardware information.");
            if (((NetworkItem)object3).isRemoteUploadEnabledForHardwareInfo()) {
                log.info((Object)"Remote uploading is enabled on the networkItem for hardware information.");
                try {
                    object2 = (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
                    if (object2 != null && ((Network)object2).getServerAddress() != null && ((Network)object2).getServerAddress().length() > 0) {
                        log.info((Object)("Network is configured to publish to '" + ((Network)object2).getServerAddress() + "'."));
                        string2 = "GUID_" + UUID.randomUUID().toString();
                        try {
                            string2 = this.cls_OsProvider.getSystemId();
                            string2 = Md5.md5(string2);
                            log.info((Object)("Will use client id '" + string2 + "' for reporting purposes. (CLIENT_ID=" + string2 + ")"));
                        }
                        catch (Exception exception) {
                            log.error((Object)("Unable to get client ID for reporting purposes.  Will use '" + string2 + "'."), (Throwable)exception);
                        }
                        log.info((Object)("Client ID for reporting is " + string2));
                        string = "";
                        if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL) != null && ((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)).getUserName().startsWith("Enrollment-") && ((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)).getPassword().startsWith("TOKEN-")) {
                            string = ((Credential)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL)).getUserName();
                        }
                        object = new ReportHandler(string2, string);
                        ((ReportHandler)object).setUrl(((Network)object2).getServerAddress());
                        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.RUNTIME_REPORT_HANDLER, object);
                        ReportHandler.SendResponse sendResponse = ((ReportHandler)object).startSession(this.cls_OsProvider, networkInterface.getNicId(), ((NetworkItem)object4).isRemoteUploadEnabledForStateInfo(), ((Network)object2).getLicensee(), null, null, false, XpcUtil.getComputerName());
                        log.info((Object)("Reporting response: " + sendResponse.getResult()));
                        log.info((Object)("Reporting content: " + sendResponse.getXml()));
                        break block24;
                    }
                    log.warn((Object)("Cannot upload reporting information since network is null or server address is blank.  Network: " + object2));
                }
                catch (Throwable throwable) {
                    log.error((Object)"An error occurred while attempting to initialize the reporting session.", throwable);
                }
            } else {
                log.info((Object)"Remote uploading of hardware information is not enabled for NetworkItem.");
            }
        }
        log.debug((Object)(Util.getShortName(this.getClass()) + " is done."));
        return DoneRequest.INSTANCE;
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (!bl) {
            log.debug((Object)("Received selection '" + dispatchResponse + "'"));
            if (dispatchResponse instanceof ContinueSelection) {
                return DoneRequest.INSTANCE;
            }
        }
        return this.doProcess(bl);
    }
}

