/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.request.LocationRequest;
import com.cloudpath.app.xpc.workflow.block.selection.LocationSelection;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.common.MacOsProvider;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkSetupReader;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class LocationBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger((String)LocationBlock.class.getName());
    private final SelectionHandler cls_SelectionHandler;
    private final OsProvider cls_OsProvider;

    public LocationBlock(SelectionHandler selectionHandler, OsProvider osProvider) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_OsProvider = osProvider;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_PROFILE};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_LOCATION};
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        log.info((Object)(this.getClass().getSimpleName() + " reset."));
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        log.info((Object)"Starting LocationBlock.doProcess...");
        if (!bl && OsConstants.isMacSnowLeopardOrLater()) {
            log.debug((Object)"System is Snow Leopard or greater.  Will check locations...");
            if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_LOCATION) == null) {
                log.debug((Object)"  - A location has not yet been selected.");
                Arguments arguments = (Arguments)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ARGUMENTS);
                boolean bl2 = false;
                if (arguments != null) {
                    bl2 = arguments.getUseCurrentLocation();
                }
                if (bl2) {
                    log.info((Object)"Arguments specified to use current location.");
                } else if (this.cls_OsProvider instanceof MacOsProvider) {
                    log.debug((Object)"  - OS provider is Mac.");
                    NetworkSetupReader networkSetupReader = ((MacOsProvider)this.cls_OsProvider).getNetworkSetupReader();
                    if (networkSetupReader != null && networkSetupReader instanceof SnowLeopardNetworkSetupReader) {
                        SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader = (SnowLeopardNetworkSetupReader)networkSetupReader;
                        log.info((Object)"Will look for Location name specified by administrator.");
                        Profile profile = (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
                        Setting setting = profile.getSettingById(Settings.SettingId.MAC_LOCATION_NAME);
                        if (setting != null) {
                            String string = snowLeopardNetworkSetupReader.getCurrentLocation();
                            String string2 = setting.getAdditionalValue();
                            log.info((Object)("Administrator has specified the location name '" + string2 + "'."));
                            if (string2.equals(string)) {
                                log.info((Object)" - Administrator specified location is the current location.");
                            } else if (snowLeopardNetworkSetupReader.hasLocation(string2)) {
                                log.info((Object)" - Administrator specified location already exists.  Will switch to it.");
                                snowLeopardNetworkSetupReader.switchLocation(string2);
                            } else {
                                log.info((Object)" - Administrator specified location does not exist.  Will create and switch to it.");
                                snowLeopardNetworkSetupReader.addLocation(string2);
                                snowLeopardNetworkSetupReader.switchLocation(string2);
                            }
                            setting.getRuntime().overrideOriginalValue("1", string, "");
                            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_LOCATION, string2);
                        } else {
                            if (snowLeopardNetworkSetupReader.getAllLocations().length > 1) {
                                log.info((Object)"More than one location exists.  We will prompt user.");
                                return new LocationRequest();
                            }
                            log.info((Object)"Only a single location exists.  Will skip prompting user.");
                        }
                    } else {
                        String string = "We were expecting an instance of SnowLeopardNetworkSetupReader but got: " + networkSetupReader;
                        log.error((Object)string, (Throwable)new Exception(string));
                    }
                }
            }
        }
        return DoneRequest.INSTANCE;
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        log.info((Object)(this.getClass().getSimpleName() + " add selection: " + dispatchResponse));
        if (dispatchResponse instanceof LocationSelection) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_LOCATION, ((LocationSelection)dispatchResponse).getLocationName());
        }
        return this.doProcess(bl);
    }
}

