/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.util.ServerHandlerImpl;
import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.request.NetworkRequest;
import com.cloudpath.app.xpc.workflow.block.selection.NetworkSelection;
import com.cloudpath.app.xpc.workflow.block.selection.SnapshotSelection;
import com.cloudpath.assess.pojo.ConfigConstants;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.Snapshot;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.pojo.Content;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import com.cloudpath.workflow.common.block.request.StartRevertRequest;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FindNetworkBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(FindNetworkBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final PersistenceHelper cls_Persistence;
    private final OsProvider cls_OsProvider;
    private String cls_PreviousSelection;
    private boolean cls_IsInitialized = false;
    private final ServerHandlerImpl cls_ServerHandler;

    public FindNetworkBlock(SelectionHandler selectionHandler, OsProvider osProvider, PersistenceHelper persistenceHelper) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_OsProvider = osProvider;
        this.cls_Persistence = persistenceHelper;
        this.cls_ServerHandler = new ServerHandlerImpl(new ParseManager(ConfigConstants.CONFIG_ELEMENTS));
    }

    private Network getNetwork() {
        return (Network)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[0];
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_NETWORK};
    }

    public GuiTab getWorkflowTab() {
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        log.info((Object)"Reseting.");
        if (this.getNetwork() != null) {
            this.cls_PreviousSelection = this.getNetwork().getName();
        }
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, null);
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, null);
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        if (bl) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, null);
            this.cls_IsInitialized = false;
            return new DoneRequest("FindNetworkBlockRevert");
        }
        if (!this.cls_IsInitialized) {
            Content content = this.wasNetworkNameProvided();
            if (content != null) {
                if (NetworkSelection.isValid(content)) {
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, content);
                    this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, (Network)content.getContent());
                } else {
                    log.warn((Object)"Config file was loaded but invalid.");
                }
            }
            this.cls_IsInitialized = true;
        }
        if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CONTENT) != null && this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK) != null) {
            log.debug((Object)"Returning DONE response.");
            return new DoneRequest("FindNetworkBlockA");
        }
        log.debug((Object)"Returning a network request.");
        return new NetworkRequest(this.cls_PreviousSelection);
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (!bl) {
            if (dispatchResponse instanceof NetworkSelection) {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.CONFIGURE);
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, ((NetworkSelection)dispatchResponse).getContent());
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, ((NetworkSelection)dispatchResponse).getNetwork());
            } else if (dispatchResponse instanceof SnapshotSelection) {
                return FindNetworkBlock.handleRevert(this.cls_SelectionHandler, this.cls_OsProvider, ((SnapshotSelection)dispatchResponse).getContent(), ((SnapshotSelection)dispatchResponse).getSnapshot());
            }
        }
        return this.doProcess(bl);
    }

    public static final DispatchRequest handleRevert(SelectionHandler selectionHandler, OsProvider osProvider, Content content, Snapshot snapshot) {
        if (!osProvider.getOsInfo().getOsName().equals(snapshot.getOs())) {
            return new ErrorRequest("Unable to load snapshot.", "The operating system has changed since the snapshot was generated.  The snapshot was generated on '" + snapshot.getOs() + "'.  The current system is running '" + osProvider.getOsInfo().getOsName() + "'.", false, true);
        }
        if (!osProvider.getOsInfo().getOsVersion().equals(snapshot.getOsVersion())) {
            return new ErrorRequest("Unable to load snapshot.", "The operating system version has changed since the snapshot was generated.  The snapshot was generated on '" + snapshot.getOsVersion() + "'.  The current system is '" + osProvider.getOsInfo().getOsVersion() + "'.", false, true);
        }
        String string = snapshot.getInterfaceGuid();
        NetworkInterface networkInterface = null;
        try {
            networkInterface = osProvider.getNicProvider().getInterface(string);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to load interface '" + string + "' for snapshot."), (Throwable)exception);
        }
        if (networkInterface == null) {
            return new ErrorRequest("Unable to load snapshot.", "The network connection '" + string + "' used to create the snapshot is no longer available.", false, true);
        }
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, content);
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, snapshot.getNetwork());
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, snapshot.getNetwork().getNetworkItem(0));
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_PROFILE, snapshot.getProfile());
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.REVERT);
        selectionHandler.setObject(WorkflowConstants.DataType.SELECTED_SNAPSHOT, snapshot);
        return new StartRevertRequest();
    }

    private Content wasNetworkNameProvided() {
        log.debug((Object)("Step wasNetworkNameProvided - " + this.getArguments().hasNetworkName()));
        if (this.getArguments().hasNetworkName()) {
            return this.wasNoRefreshSpecified();
        }
        return this.wasNetworkUrlProvided();
    }

    private Content wasNoRefreshSpecified() {
        log.debug((Object)("Step wasNoRefreshSpecified - " + this.getArguments().getNoRefresh()));
        if (this.getArguments().getNoRefresh()) {
            return this.isConfigFileAvailableLocally();
        }
        return this.wasNetworkUrlProvided();
    }

    private Content wasNetworkUrlProvided() {
        log.debug((Object)"Step wasNetworkUrlProvided");
        if (this.getArguments().hasNetworkUrl()) {
            return this.doQueryConfigBySpecifiedUrl();
        }
        return this.doCheckAppPath();
    }

    private Content isConfigFileAvailableLocally() {
        log.debug((Object)"Step isConfigFileAvailableLocally");
        Content content = this.cls_Persistence.getNetworkConfig(this.getArguments().getNetworkName());
        if (content != null && content.isValid()) {
            log.debug((Object)"Config file was found.");
            return content;
        }
        return this.wasNetworkUrlProvided();
    }

    private Content wasConfigRetrieved(String string, Content content) {
        log.debug((Object)"Step wasConfigRetrieved");
        if (content != null && content.getContent() != null && content.getContent() instanceof Network) {
            if (((Network)content.getContent()).getRefreshUrl().length() == 0) {
                ((Network)content.getContent()).setRefreshUrl(string);
            }
            return this.doWriteToDisk(content);
        }
        return this.doCheckAppPath();
    }

    private Content doQueryConfigBySpecifiedUrl() {
        log.debug((Object)"Step doQueryConfigBySpecifiedUrl");
        Content content = this.cls_ServerHandler.getContentFromUrl(this.getArguments().getNetworkUrl());
        return this.wasConfigRetrieved(this.getArguments().getNetworkUrl(), content);
    }

    private Content doCheckAppPath() {
        log.debug((Object)"Step DoCheckAppPath");
        Content content = null;
        try {
            log.info((Object)"Will attempt to load network_config from jar file...");
            String string = FileUtil.read("network_config.xml");
            ParseManager parseManager = new ParseManager(ConfigConstants.CONFIG_ELEMENTS);
            content = (Content)parseManager.parse(string);
            log.info((Object)"Network_config loaded from jar file.");
            log.info((Object)("Content: " + content));
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to find network_config in jar.", (Throwable)iOException);
        }
        catch (InvalidXmlException invalidXmlException) {
            log.error((Object)"Unable to parse the network_config in the jar.", (Throwable)invalidXmlException);
        }
        if (content != null) {
            return this.doWriteToDisk(content);
        }
        return this.doCheckExistingConfigs();
    }

    private Content doCheckExistingConfigs() {
        Content content;
        log.debug((Object)"Step doCheckExistingConfigs");
        String[] stringArray = this.cls_Persistence.getNetworkConfigNames();
        if (stringArray != null && stringArray.length == 1 && (content = this.cls_Persistence.getNetworkConfig(stringArray[0])) != null) {
            return content;
        }
        log.debug((Object)"Will need to prompt user.");
        return null;
    }

    private Content doWriteToDisk(Content content) {
        log.debug((Object)"Step doWriteToDisk");
        this.cls_Persistence.saveNetworkConfig(content);
        return content;
    }

    private Arguments getArguments() {
        return (Arguments)(this.cls_SelectionHandler != null ? this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.ARGUMENTS) : null);
    }
}

