/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.workflow.block.request.SystemCredentialRequest;
import com.cloudpath.app.xpc.workflow.block.selection.CredentialSelection;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.report.client.ReportHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import org.apache.log4j.Logger;

public class ElevationBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(ElevationBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final boolean cls_ForRevert;

    public ElevationBlock(SelectionHandler selectionHandler, boolean bl) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_ForRevert = bl;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[0];
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[0];
    }

    public GuiTab getWorkflowTab() {
        if (this.cls_ForRevert) {
            return this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE) != null ? XpcConstants.CONNECTED : null;
        }
        return XpcConstants.WELCOME;
    }

    public boolean reset() {
        return true;
    }

    public synchronized DispatchRequest doProcess(boolean bl) {
        log.debug((Object)"Will process.");
        Boolean bl2 = (Boolean)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_ELEVATION);
        if (bl2 != null && bl2.booleanValue()) {
            log.debug((Object)"Elevation has been verified.");
            try {
                if (this.getNetworkItem().isRemoteUploadEnabledForStateInfo()) {
                    ReportHandler reportHandler = (ReportHandler)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_REPORT_HANDLER);
                    reportHandler.updateSession_AdminElevated();
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while doing reporting.", (Throwable)exception);
            }
            return new DoneRequest("ElevationBlockA");
        }
        NetworkItem networkItem = (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
        if (networkItem != null && networkItem.getAdminInfo() != null && networkItem.getAdminInfo().length() > 0) {
            log.debug((Object)"Will attempt to install for standard user.");
            String string = networkItem.getAdminPassword();
            String string2 = networkItem.getAdminUserName();
            BanishedWords.add(string, "[PASSWORD]");
            BanishedWords.add("su " + string2 + " -c", "[CMD1]");
            BanishedWords.add("sudo -S", "[CMD2]");
            BanishedWords.add("sudo -k", "[CMD3]");
            return new SystemCredentialRequest(SystemCredentialRequest.CredentialBehavior.AS_STANDARD_USER, networkItem.getAdminUserName(), string);
        }
        log.debug((Object)"Returning admin credential request to request that user verify they can elevate.");
        return new SystemCredentialRequest(SystemCredentialRequest.CredentialBehavior.AS_ADMIN);
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        log.info((Object)("Selection is: " + dispatchResponse));
        if (dispatchResponse instanceof CredentialSelection) {
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.VERIFIED_ELEVATION, Boolean.TRUE);
            return this.doProcess(bl);
        }
        log.error((Object)("Unknown selection: " + dispatchResponse));
        return this.doProcess(bl);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }
}

