/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.workflow.block;

import com.cloudpath.app.xpc.util.XpcConstants;
import com.cloudpath.app.xpc.util.XpcUtil;
import com.cloudpath.app.xpc.workflow.block.request.NotifyConnectedRequest;
import com.cloudpath.assess.pojo.Condition;
import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.util.Modifications;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.dispatch.TerminateRequest;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.report.client.ReportHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.BlockUtil;
import com.cloudpath.workflow.common.block.WorkflowBlock;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ConnectedBlock
implements WorkflowBlock {
    private static final Logger log = Logger.getLogger(ConnectedBlock.class);
    private final SelectionHandler cls_SelectionHandler;
    private final AsyncHandler cls_AsyncHandler;
    private final OsProvider cls_OsProvider;
    private boolean cls_EndpointUrlSent = false;

    public ConnectedBlock(SelectionHandler selectionHandler, AsyncHandler asyncHandler, OsProvider osProvider) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_AsyncHandler = asyncHandler;
        this.cls_OsProvider = osProvider;
    }

    public WorkflowConstants.DataType[] getPrerequisites() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, WorkflowConstants.DataType.MODIFICATIONS};
    }

    public WorkflowConstants.DataType[] getGuaranteedOutput() {
        return new WorkflowConstants.DataType[]{WorkflowConstants.DataType.CONNECTED};
    }

    public GuiTab getWorkflowTab() {
        return this.getProfile() != null ? XpcConstants.CONNECTED : null;
    }

    private String getSsid() {
        return (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME);
    }

    private NetworkInterface getInterface() {
        return (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
    }

    public boolean reset() {
        this.cls_EndpointUrlSent = false;
        return true;
    }

    private boolean getMigrationBehavior() {
        switch (this.getNetworkItem().getMigrationBehavior()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.cls_OsProvider.getWirelessProvider().ssidIsInScanList(this.getInterface().getName(), this.getSsid());
            }
        }
        return true;
    }

    public DispatchRequest doProcess(boolean bl) {
        Object object;
        if (bl) {
            BlockUtil.sendAsync(this.cls_AsyncHandler, new WaitRequest("Reverting Changes", "We are undoing the previous modifications.", "/loading.gif"));
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.CONNECTED, null);
            return new DoneRequest("ConnectedBlockA");
        }
        if (!this.getMigrationBehavior() && !this.cls_EndpointUrlSent && (object = this.getNetworkItem().getEndpointUrl()) != null && ((String)object).length() > 0) {
            object = XpcUtil.replaceVariables((String)object, this.cls_SelectionHandler);
            try {
                log.debug((Object)("Opening post-transition url '" + (String)object + "'."));
                this.cls_OsProvider.openBrowser((String)object);
            }
            catch (Exception exception) {
                log.warn((Object)("Failed to open browser to '" + (String)object + "'."), (Throwable)exception);
            }
            this.cls_EndpointUrlSent = true;
        }
        if (this.getNetworkItem().isRemoteUploadEnabledForStateInfo()) {
            log.info((Object)"Will update state in reports to indicate we were successful.");
            object = (ReportHandler)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.RUNTIME_REPORT_HANDLER);
            if (object != null) {
                ReportHandler.SendResponse sendResponse = ((ReportHandler)object).updateSession_Complete();
                log.info((Object)("Report result: " + sendResponse.getResult()));
                log.info((Object)("Report Data: " + sendResponse.getXml()));
            }
        }
        if (this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CONNECTED) != null) {
            log.debug((Object)"Returning DONE response.");
            return new DoneRequest("ConnectedBlockB");
        }
        if (this.getNetworkItem().getCompletionBehavior() == 2) {
            log.info((Object)"Completion behavior is to automatically close.  Will close.");
            return new TerminateRequest();
        }
        if (this.getNetworkItem().getCompletionBehavior() == 4) {
            log.info((Object)"Completion behavior is to goto another network.");
            if (this.getNextNetworkItem(true) != null) {
                log.info((Object)"\n\n****** WILL GO TO NEXT NETWORK ************\n\n");
                return new StartOverRequest("CompletionBehaviorGotoNextNetwork", StartingPoint.CONFIGURE, true);
            }
            log.info((Object)"There was no 'next network' item to go to.  Moving on..");
        } else if (this.getNetworkItem().getCompletionBehavior() == 5) {
            log.info((Object)"Completion behavior is to goto another network without the nic.");
            if (this.getNextNetworkItem(false) != null) {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, null);
                return new StartOverRequest("CompletionBehaviorGotoNextNetwork", StartingPoint.CONFIGURE, true);
            }
            log.info((Object)"There was no 'next network' item to go to.  Moving on..");
        }
        log.debug((Object)"Returning a NotifyConnectedRequest.");
        object = (Modifications)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.MODIFICATIONS);
        boolean bl2 = null == this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_RECONNECT_COMPLETED) || null == this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED) || null == this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_CONNECTION_VALIDATED);
        log.debug((Object)("Final Selection Handler Information: \n" + this.cls_SelectionHandler.print()));
        String string = (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SKIP_MESSAGES);
        return new NotifyConnectedRequest(((Modifications)object).getChanges().length > 0, (Modifications)object, this.getNetworkItem().getCompletionBehavior() == 1, bl2, string, (String)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.VERIFIED_IP_RECEIVED), this.getMigrationBehavior());
    }

    public DispatchRequest addSelection(DispatchResponse dispatchResponse, boolean bl) {
        if (bl) {
            // empty if block
        }
        return this.doProcess(bl);
    }

    private NetworkItem getNetworkItem() {
        return (NetworkItem)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
    }

    private Profile getProfile() {
        return (Profile)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
    }

    private NetworkItem getNextNetworkItem(boolean bl) {
        Condition[] conditionArray;
        Object object;
        log.info((Object)"Will check if next network_item has a profile for this operating system & nic.");
        SelectionHandler selectionHandler = this.cls_SelectionHandler;
        Network network = (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
        NetworkItem networkItem = (NetworkItem)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
        String string = networkItem.getName();
        NetworkItem networkItem2 = network.getNextNetworkItem(string);
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        Object object2 = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS);
        if (object2 != null) {
            log.debug((Object)(" - Adding condition for os " + object2));
            arrayList.add(new Condition(Condition.ConditionKey.OS, Condition.ConditionOperator.EQ, object2.toString()));
        }
        if ((object = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.CURRENT_OS_VERSION)) != null) {
            log.debug((Object)(" - Adding condition for version " + object));
            arrayList.add(new Condition(Condition.ConditionKey.VERSION, Condition.ConditionOperator.EQ, object.toString()));
        }
        if (bl && (conditionArray = this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE)) != null) {
            log.debug((Object)" - Adding condition for nic type.");
            arrayList.add(new Condition(Condition.ConditionKey.TYPE, Condition.ConditionOperator.EQ, ((NetworkInterface)conditionArray).getInterfaceType() + ""));
        }
        log.debug((Object)("Getting potential profiles for " + arrayList.size() + " conditions."));
        conditionArray = new Condition[arrayList.size()];
        arrayList.toArray(conditionArray);
        log.debug((Object)("Will find potential profiles from network's " + networkItem2.getProfileCount() + " profiles."));
        Profile[] profileArray = networkItem2.getPotentialProfiles(conditionArray);
        if (profileArray != null && profileArray.length > 0) {
            log.info((Object)"Yes, a next network item exists for this OS & nic.");
            return networkItem2;
        }
        log.info((Object)"No, a next network item does not exist for this OS & nic.");
        return null;
    }
}

