/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.util;

import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.Settings;
import com.cloudpath.common.os.mac.common.provider.MacSystemProvider;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Credential;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.Xmlable;
import com.cloudpath.workflow.common.WorkflowConstants;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpcUtil {
    private static final Logger log = Logger.getLogger(XpcUtil.class);
    private static MacSystemProvider SYSTEM_PROVIDER = null;
    public static final String[] ALL_VARIABLES = new String[]{"CURRENT_USER", "USER_NAME", "PASSWORD", "DOMAIN", "SSID", "BASE_URL", "MAC_ADDRESS", "IP_ADDRESS", "INTERFACE_TYPE", "DRIVER_PROVIDER", "DRIVER_VERSION", "NIC_PROVIDER", "PHYSICAL_NIC_NAME", "PHYSICAL_INTERFACE", "OS", "OS_VERSION", "OS_SP", "FULL_OS", "VERSION", "COMPUTER_NAME", "COMPUTER_MODEL", "COMPUTER_MANUFACTURER"};

    public static void setSystemProvider(MacSystemProvider macSystemProvider) {
        SYSTEM_PROVIDER = macSystemProvider;
    }

    public static String replaceVariables(String string, SelectionHandler selectionHandler) {
        return XpcUtil.replaceVariables(string, selectionHandler, false);
    }

    public static String replaceVariables(String string, SelectionHandler selectionHandler, boolean bl) {
        return XpcUtil.replaceVariables(string, selectionHandler, bl, null);
    }

    public static String replaceVariables(String string, SelectionHandler selectionHandler, boolean bl, Credential credential) {
        if (string != null && string.contains("${")) {
            Xmlable xmlable;
            Object object;
            if (selectionHandler != null) {
                object = credential != null ? credential : (Credential)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
                xmlable = (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
                NetworkInterface networkInterface = (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
                string = Util.replaceVariable(string, "CURRENT_USER", System.getProperty("user.name"), bl);
                string = Util.replaceVariable(string, "USER_NAME", object != null ? ((Credential)object).getUserName() : "", bl);
                string = Util.replaceVariable(string, "USERNAME", object != null ? ((Credential)object).getUserName() : "", bl);
                string = Util.replaceVariable(string, "PASSWORD", object != null ? ((Credential)object).getPassword() : "", bl);
                string = Util.replaceVariable(string, "DOMAIN", object != null ? ((Credential)object).getDomain() : "", bl);
                string = Util.replaceVariable(string, "SSID", (String)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME), bl);
                string = Util.replaceVariable(string, "BASE_URL", xmlable != null ? ((Network)xmlable).getBaseUrl() : "", bl);
                string = Util.replaceVariable(string, "MAC_ADDRESS", networkInterface != null && networkInterface.getMacAddress() != null ? networkInterface.getMacAddress().toUpperCase() : "", bl);
                string = Util.replaceVariable(string, "IP_ADDRESS", networkInterface != null ? networkInterface.getIpAddress() : "", bl);
                string = Util.replaceVariable(string, "INTERFACE_TYPE", networkInterface != null ? networkInterface.getInterfaceType() + "" : "", bl);
                string = Util.replaceVariable(string, "DRIVER_PROVIDER", "Apple", bl);
                string = Util.replaceVariable(string, "DRIVER_VERSION", "Apple", bl);
                string = Util.replaceVariable(string, "NIC_PROVIDER", "Apple", bl);
                string = Util.replaceVariable(string, "PHYSICAL_NIC_NAME", networkInterface != null ? networkInterface.getPhysicalCardName() : "", bl);
                string = Util.replaceVariable(string, "NIC_DETAILS", networkInterface != null ? networkInterface.toString() : "", bl);
                string = Util.replaceVariable(string, "NETWORK_CONNECTION", networkInterface != null ? networkInterface.getName() : "", bl);
                string = Util.replaceVariable(string, "PHYSICAL_INTERFACE", networkInterface != null ? networkInterface.getPhysicalCardName() : "", bl);
            }
            string = Util.replaceVariable(string, "OS", MacSystemProvider.getOsType(), bl);
            string = Util.replaceVariable(string, "OS_VERSION", MacSystemProvider.getOsVersion(), bl);
            string = Util.replaceVariable(string, "OS_SP", "" + MacSystemProvider.getOsServicePack(), bl);
            string = Util.replaceVariable(string, "FULL_OS", MacSystemProvider.getOsFullVersion(), bl);
            string = Util.replaceVariable(string, "VERSION", "5.0.255", bl);
            string = Util.replaceVariable(string, "country_2", Locale.getDefault().getCountry().toLowerCase(), bl);
            string = Util.replaceVariable(string, "COUNTRY_2", Locale.getDefault().getCountry().toUpperCase(), bl);
            string = Util.replaceVariable(string, "country_3", Locale.getDefault().getISO3Country().toLowerCase(), bl);
            string = Util.replaceVariable(string, "COUNTRY_3", Locale.getDefault().getISO3Country().toUpperCase(), bl);
            string = Util.replaceVariable(string, "language_2", Locale.getDefault().getLanguage().toLowerCase(), bl);
            string = Util.replaceVariable(string, "LANGUAGE_2", Locale.getDefault().getLanguage().toUpperCase(), bl);
            string = Util.replaceVariable(string, "language_3", Locale.getDefault().getISO3Language().toLowerCase(), bl);
            string = Util.replaceVariable(string, "LANGUAGE_3", Locale.getDefault().getISO3Language().toUpperCase(), bl);
            object = "x86_64".equals(System.getProperty("os.arch")) ? "32" : ("x86".equals(System.getProperty("os.arch")) ? "32" : ("x64".equals(System.getProperty("os.arch")) ? "64" : System.getProperty("os.arch")));
            string = Util.replaceVariable(string, "arch", (String)object, bl);
            string = Util.replaceVariable(string, "ARCH", (String)object, bl);
            if (SYSTEM_PROVIDER != null) {
                if (string.contains("${COMPUTER_NAME}")) {
                    string = Util.replaceVariable(string, "COMPUTER_NAME", SYSTEM_PROVIDER.getComputerName(), bl);
                }
                if (string.contains("${COMPUTER_MODEL}")) {
                    string = Util.replaceVariable(string, "COMPUTER_MODEL", SYSTEM_PROVIDER.getComputerModel(), bl);
                }
                if (string.contains("${COMPUTER_MANUFACTURER}")) {
                    string = Util.replaceVariable(string, "COMPUTER_MANUFACTURER", SYSTEM_PROVIDER.getComputerManufacturer(), bl);
                }
            }
            if (selectionHandler != null) {
                xmlable = (Profile)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
                int n = 0;
                while (string.indexOf("${SETTING_", n) >= 0) {
                    log.debug((Object)("Will replace setting variables in: " + string));
                    n = string.indexOf("${SETTING_");
                    int n2 = string.indexOf("}", n);
                    String string2 = string.substring(n, n2 + 1);
                    log.debug((Object)(" - Variable is '" + string2 + "'."));
                    long l = XpcUtil.getVariableSettingId(string2);
                    String string3 = string2;
                    log.debug((Object)(" - Setting id is '" + l + "'."));
                    if (l > 0L) {
                        string3 = "";
                        boolean bl2 = false;
                        try {
                            Settings.SettingId settingId = Settings.getSettingId(l);
                            log.debug((Object)(" - Instance is '" + (Object)((Object)settingId) + "'."));
                            if (xmlable != null) {
                                for (int i = 0; i < ((Profile)xmlable).getSectionCount() && !bl2; ++i) {
                                    log.debug((Object)("  - Looking at section " + i + "..."));
                                    if (((Profile)xmlable).getSection(i) == null) continue;
                                    Setting setting = ((Profile)xmlable).getSection(i).getSettingById(settingId);
                                    log.debug((Object)(setting == null ? "   - No setting found." : "   - Found setting: " + setting));
                                    if (setting == null) continue;
                                    if (setting.getRuntime().isCurrentValueCorrect()) {
                                        log.debug((Object)"    - Correct");
                                        string3 = "1";
                                    } else {
                                        log.debug((Object)"    - Wrong");
                                        string3 = "0";
                                    }
                                    bl2 = true;
                                }
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            log.error((Object)(" - Unable to parse setting id '" + l + "'  This is an invalid configuration.  Will not replace '" + string2 + "' variable."));
                        }
                        log.debug((Object)(" - Replacing '" + string2 + "' with '" + string3 + "'."));
                        string = Util.replaceVariable(string, "SETTING_" + l, string3, bl);
                    }
                    n += string3.length();
                }
                log.debug((Object)("Resulting text is '" + string + "'."));
            }
        }
        return string;
    }

    static long getVariableSettingId(String string) {
        if (string != null && string.startsWith("${SETTING_") && string.endsWith("}")) {
            string = string.substring(10, string.length() - 1);
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static HashMap<String, String> createVariableMap(SelectionHandler selectionHandler) {
        return XpcUtil.createVariableMap(selectionHandler, null);
    }

    public static HashMap<String, String> createVariableMap(SelectionHandler selectionHandler, Credential credential) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (selectionHandler != null) {
            if (credential == null) {
                credential = (Credential)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL);
            }
            Network network = (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
            NetworkInterface networkInterface = (NetworkInterface)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
            hashMap.put("CURRENT_USER", System.getProperty("user.name"));
            if (credential != null) {
                hashMap.put("USER_NAME", credential != null ? credential.getUserName() : "");
                hashMap.put("USERNAME", credential != null ? credential.getUserName() : "");
                hashMap.put("PASSWORD", credential != null ? credential.getPassword() : "");
                hashMap.put("DOMAIN", credential != null ? credential.getDomain() : "");
            }
            hashMap.put("SSID", (String)selectionHandler.getObject(WorkflowConstants.DataType.DESIRED_SSID_NAME));
            if (network != null) {
                hashMap.put("BASE_URL", network != null ? network.getBaseUrl() : "");
            }
            if (networkInterface != null) {
                hashMap.put("MAC_ADDRESS", networkInterface != null ? networkInterface.getMacAddress() : "");
                hashMap.put("IP_ADDRESS", networkInterface != null ? networkInterface.getIpAddress() : "");
                hashMap.put("INTERFACE_TYPE", networkInterface != null ? networkInterface.getInterfaceTypeName() : "");
                hashMap.put("DRIVER_PROVIDER", "Apple");
                hashMap.put("DRIVER_VERSION", "Apple");
                hashMap.put("NIC_PROVIDER", "Apple");
                hashMap.put("PHYSICAL_NIC_NAME", networkInterface != null ? networkInterface.getPhysicalCardName() : "");
                hashMap.put("NIC_DETAILS", networkInterface != null ? networkInterface.toString() : "");
                hashMap.put("NETWORK_CONNECTION", networkInterface != null ? networkInterface.getName() : "");
                hashMap.put("PHYSICAL_INTERFACE", networkInterface != null ? networkInterface.getPhysicalCardName() : "");
            }
        }
        hashMap.put("OS", MacSystemProvider.getOsType());
        hashMap.put("OS_VERSION", MacSystemProvider.getOsVersion());
        hashMap.put("OS_SP", "" + MacSystemProvider.getOsServicePack());
        hashMap.put("FULL_OS", MacSystemProvider.getOsFullVersion());
        hashMap.put("VERSION", "5.0.255");
        if (SYSTEM_PROVIDER != null) {
            hashMap.put("COMPUTER_NAME", SYSTEM_PROVIDER.getComputerName());
            hashMap.put("COMPUTER_MODEL", SYSTEM_PROVIDER.getComputerModel());
        }
        return hashMap;
    }

    public static boolean isGuestMode() {
        String string = "cloudpath.guestmode";
        String string2 = "jnlp." + string;
        return System.getProperties().containsKey(string) && "1".equals(System.getProperties().getProperty(string)) || System.getProperties().containsKey(string2) && "1".equals(System.getProperties().getProperty(string2));
    }

    public static String getComputerName() {
        return SYSTEM_PROVIDER != null ? SYSTEM_PROVIDER.getComputerName() : "";
    }
}

