/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.AssociateToSsidRequest;
import com.cloudpath.app.xpc.workflow.block.selection.RepairSectionSelection;
import com.cloudpath.assess.util.PojoUtil;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.util.Resources;
import com.cloudpath.gui.component.XpcLink;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class TigerAuthenticateForm
extends XpcPromptForm
implements XpcLinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TigerAuthenticateForm.class);
    private static int LINK_SKIP = 1;
    private static int LINK_RETRY = 2;
    private static int LINK_HELP = 3;
    private final AssociateToSsidRequest cls_Request;
    private final OsProvider cls_OsProvider;

    public TigerAuthenticateForm(FormListener formListener, AssociateToSsidRequest associateToSsidRequest, OsProvider osProvider) {
        super(formListener, associateToSsidRequest.getRequiresAuthentication() ? "Authentication Required" : "Waiting for Association", null, null);
        this.setLoading(true);
        this.cls_Request = associateToSsidRequest;
        this.cls_OsProvider = osProvider;
        String string = associateToSsidRequest.getNetworkItem().getPreCredentialText();
        if (string == null || string.length() == 0) {
            string = PojoUtil.getResourceString(Resources.ResourceString.PRE_CREDENTIAL_TEXT, null, associateToSsidRequest.getNetworkItem(), null);
        }
        string = string + "<br><br>The form pictured below will open.  When it does, verify that <b>Configuration</b> is set to '" + associateToSsidRequest.getProfileName() + "'  Enter your user name and password and click 'Connect'.  If a form labeled \"802.1X Authentication\" displays, click \"Continue\".";
        JPanel jPanel = new JPanel(new BorderLayout(15, 5));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel("<html>" + string + "</html>");
        jPanel.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel(GuiConstants.getImage("/mac_authenticate.gif"));
        jLabel2.setBackground(Color.GREEN);
        jPanel.add((Component)jLabel2, "Center");
        XpcPanel xpcPanel = new XpcPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 10));
        jPanel2.setOpaque(false);
        jPanel2.add((Component)new XpcLink("Skip", LINK_SKIP, this, true), "West");
        jPanel2.add((Component)new XpcLink("Retry", LINK_RETRY, this, true), "East");
        xpcPanel.add((Component)jPanel2, "West");
        String string2 = associateToSsidRequest.getNetworkItem().getPreCredentialHelpLinkName();
        String string3 = associateToSsidRequest.getNetworkItem().getPreCredentialHelpLinkUrl();
        if (string2 != null && string3 != null && string2.length() > 0 && string3.length() > 0) {
            JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 10));
            jPanel3.setOpaque(false);
            XpcLink xpcLink = new XpcLink(string2, LINK_HELP, this, true);
            jPanel3.add(xpcLink);
            xpcPanel.add((Component)jPanel3, "East");
        }
        jPanel.add((Component)xpcPanel, "South");
    }

    public DispatchResponse getSelection() {
        return new RepairSectionSelection(RepairSectionSelection.Action.REPAIR);
    }

    public void linkClicked(int n) {
        if (n == LINK_SKIP) {
            log.debug((Object)"User clicked skip.");
            this.selectionMade(new SkipSelection("- Authentication was skipped."));
        } else if (n == LINK_RETRY) {
            log.debug((Object)"User clicked retry.");
            this.selectionMade(new RetrySelection());
        } else if (n == LINK_HELP) {
            log.debug((Object)"User clicked help link.");
            String string = this.cls_Request.getNetworkItem().getPreCredentialHelpLinkUrl();
            if (string.startsWith("http")) {
                if (this.cls_Request.getOriginalSsid() != null && this.cls_Request.getOriginalSsid().length() > 0) {
                    try {
                        WirelessAssociation wirelessAssociation = this.cls_OsProvider.getWirelessProvider().getCurrentAssociation(this.cls_Request.getInterfaceGuid());
                        if (!wirelessAssociation.isAssociated()) {
                            log.debug((Object)("Will attempt to reconnect to original ssid '" + this.cls_Request.getOriginalSsid() + "'"));
                            this.cls_OsProvider.getWirelessProvider().connectToOpenSsid(this.cls_Request.getInterfaceGuid(), this.cls_Request.getOriginalSsid());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.cls_OsProvider.openBrowser(string);
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to open browser for help link '" + string + "'."), (Throwable)exception);
                    JOptionPane.showMessageDialog(this, "<html>Additional information is available at: " + string + "<br><br></html>", "Help", 1);
                }
            } else {
                string = GuiConstants.createMessage(string);
                JOptionPane.showMessageDialog(this, "<html>" + string + "<br><br></html>", "Help", 1);
            }
        }
    }
}

