/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.RevertCompleteRequest;
import com.cloudpath.common.dispatch.RetrySelection;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.dispatch.TerminateSelection;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.gui.form.WaitForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.workflow.common.block.selection.StartOverSelection;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class RevertCompleteForm
extends WaitForm
implements HyperlinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(RevertCompleteForm.class);
    private static final String LINK_REJOIN = "CPN-REJOIN";

    public RevertCompleteForm(FormListener formListener, RevertCompleteRequest revertCompleteRequest) {
        super(formListener, new WaitRequest("Revert complete.", "Your machine has been successfully restored to its configuration prior to joining the " + revertCompleteRequest.getSnapshot().getNetwork().getName() + " network on " + revertCompleteRequest.getSnapshot().getTimestamp() + ".<br><br>To rejoin the network, <a href='" + LINK_REJOIN + "'>click here</a>.", null, null, "Done", new RetrySelection(), "/success.gif"), null);
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && hyperlinkEvent.getDescription().equals(LINK_REJOIN)) {
            log.info((Object)"User has selected to rejoin.");
            this.selectionMade(new StartOverSelection(StartingPoint.CONFIGURE));
        }
    }

    public void backClicked() {
    }

    public void nextClicked() {
        log.info((Object)"User has selected to exit application.");
        this.selectionMade(new TerminateSelection());
    }
}

