/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.util.PersistenceHelper;
import com.cloudpath.app.xpc.workflow.block.request.NetworkRequest;
import com.cloudpath.app.xpc.workflow.block.selection.NetworkSelection;
import com.cloudpath.app.xpc.workflow.block.selection.SnapshotSelection;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.pojo.Content;
import com.cloudpath.gui.component.XpcButtonListItem;
import com.cloudpath.gui.component.XpcListItem;
import com.cloudpath.gui.component.XpcListPanel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import java.awt.Component;
import org.apache.log4j.Logger;

public class NetworkSelectionForm
extends XpcPromptForm {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(NetworkSelectionForm.class);
    private final XpcListPanel cls_ListPanel;
    private final PersistenceHelper cls_PersistenceHelper;
    private final String[] cls_NetworkNames;
    private final Content cls_LastSnapshot;

    public NetworkSelectionForm(FormListener formListener, NetworkRequest networkRequest, PersistenceHelper persistenceHelper) {
        super(formListener, "What would you like to do?", null, "Continue >");
        Object object;
        this.cls_PersistenceHelper = persistenceHelper;
        this.cls_NetworkNames = persistenceHelper.getNetworkConfigNames();
        this.cls_LastSnapshot = persistenceHelper.getLastSnapshot();
        this.cls_ListPanel = new XpcListPanel(this);
        int n = 0;
        for (int i = 0; i < this.cls_NetworkNames.length; ++i) {
            object = "Join " + this.cls_NetworkNames[i];
            XpcButtonListItem xpcButtonListItem = new XpcButtonListItem(48, this.cls_NetworkNames.length > 3, (String)object, null, i, this, 0);
            this.cls_ListPanel.addListItem(xpcButtonListItem);
            if (networkRequest.getNetworkName() == null || !networkRequest.getNetworkName().equals(this.cls_NetworkNames[i])) continue;
            n = i;
        }
        if (this.cls_LastSnapshot != null) {
            String string = "Revert Previous Changes";
            object = new XpcButtonListItem(48, this.cls_NetworkNames.length > 3, string, null, this.cls_NetworkNames.length, this, 0);
            this.cls_ListPanel.addListItem((XpcListItem)object);
        }
        this.cls_ListPanel.setSelected(n);
        this.add((Component)this.cls_ListPanel, "Center");
    }

    public DispatchResponse getSelection() {
        int n = this.cls_ListPanel.getSelected();
        log.debug((Object)("Selection: " + n));
        if (n < 0) {
            return null;
        }
        if (n >= this.cls_NetworkNames.length) {
            log.debug((Object)"Returning snapshot.");
            return new SnapshotSelection(this.cls_LastSnapshot);
        }
        String string = this.cls_NetworkNames[n];
        log.debug((Object)("Returning network " + string));
        Content content = this.cls_PersistenceHelper.getNetworkConfig(string);
        if (content != null && content.isValid()) {
            System.err.println("Should notify user of invalid checksum.");
        }
        return new NetworkSelection(content);
    }

    public void upClicked() {
        this.cls_ListPanel.moveUp();
    }

    public void downClicked() {
        this.cls_ListPanel.moveDown();
    }
}

