/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.gui.form.control.ManualFixItem;
import com.cloudpath.app.xpc.workflow.block.request.RepairSectionRequest;
import com.cloudpath.app.xpc.workflow.block.selection.RepairSectionSelection;
import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcButtonPanel;
import com.cloudpath.gui.component.XpcLink;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcListPanel;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ManualRepairForm
extends XpcPromptForm
implements XpcLinkListener,
ActionListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ManualRepairForm.class);
    private static final String ACTION_REFRESH = "REFRESH";
    private static final String ACTION_SKIP = "SKIP";
    private final XpcListPanel cls_ListPanel;
    private final RepairSectionRequest cls_Request;
    private final OsProvider cls_OsProvider;
    private final ManualRepairHeaderPanel cls_Header = (ManualRepairHeaderPanel)this.getOriginalHeaderPanel();

    public ManualRepairForm(FormListener formListener, RepairSectionRequest repairSectionRequest, OsProvider osProvider) {
        super(formListener, new ManualRepairHeaderPanel(), "", "Fix All >");
        int n;
        this.cls_Request = repairSectionRequest;
        this.cls_OsProvider = osProvider;
        String[] stringArray = new String[repairSectionRequest.getIncorrectSettings().length];
        boolean[] blArray = new boolean[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = repairSectionRequest.getIncorrectSettings()[n].getRuntime().getDisplayText();
            blArray[n] = repairSectionRequest.getIncorrectSettings()[n].getRuntime().hasHelp();
        }
        this.cls_ListPanel = new XpcListPanel(this);
        for (n = 0; n < repairSectionRequest.getIncorrectSettings().length; ++n) {
            Setting setting = repairSectionRequest.getIncorrectSettings()[n];
            ManualFixItem manualFixItem = new ManualFixItem(this, n, 1000 + n, setting.getRuntime().isOptional() ? ManualFixItem.IconType.OPTIONAL : ManualFixItem.IconType.REQUIRED, setting.getRuntime().getDisplayText(), setting.getRuntime().getDisplayHelp(), setting.getRuntime().getDisplayHelpUrl(), setting.getCanAutoFix());
            this.cls_ListPanel.addListItem(manualFixItem);
        }
        this.cls_ListPanel.addFiller();
        this.cls_ListPanel.setSelected(0);
        this.add((Component)this.cls_ListPanel, "Center");
        this.cls_Header.addButton("Refresh", ACTION_REFRESH, this, "Setting will be reloaded.");
        if (repairSectionRequest.isAllOptional()) {
            this.cls_Header.addButton("Skip", ACTION_SKIP, this, "Settings will be ignored.");
        }
        this.getRightButton().setEnabled(repairSectionRequest.isAllAutoFix());
    }

    public DispatchResponse getSelection() {
        return new RepairSectionSelection(RepairSectionSelection.Action.REPAIR);
    }

    private void refreshClicked() {
        this.selectionMade(new RepairSectionSelection(RepairSectionSelection.Action.REFRESH));
    }

    public void skipClicked() {
        for (int i = 0; i < this.cls_Request.getIncorrectSettings().length; ++i) {
            if (this.cls_Request.getIncorrectSettings()[i] == null || this.cls_Request.getIncorrectSettings()[i].getIsRequired()) continue;
            this.cls_Request.getIncorrectSettings()[i].getRuntime().setWasSkipped(true);
        }
        this.selectionMade(new SkipSelection("Skipped by user request (1020)."));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        log.info((Object)("User selected " + actionEvent.getActionCommand()));
        if (ACTION_REFRESH.equals(actionEvent.getActionCommand())) {
            this.refreshClicked();
        } else if (ACTION_SKIP.equals(actionEvent.getActionCommand())) {
            this.skipClicked();
        }
    }

    public void linkClicked(int n) {
        if (n >= 1000) {
            this.fixSetting(n - 1000);
        } else {
            this.openHelp(n);
        }
    }

    private void fixSetting(int n) {
        log.info((Object)("User selected to fix setting " + this.cls_Request.getIncorrectSettings()[n].getRuntime().getDisplayText()));
        this.selectionMade(new RepairSectionSelection(new Setting[]{this.cls_Request.getIncorrectSettings()[n]}));
    }

    private void openHelp(int n) {
        log.info((Object)("User selected to open help for setting " + this.cls_Request.getIncorrectSettings()[n].getRuntime().getDisplayText()));
        Setting setting = this.cls_Request.getIncorrectSettings()[n];
        String string = setting.getRuntime().getDisplayHelpUrl();
        String string2 = setting.getRuntime().getDisplayHelp();
        if (string2 != null && string2.length() > 0) {
            String string3 = "";
            if (string != null && string.length() > 0) {
                string3 = "To assist with this setting, your browser has been opened to " + string + ".<br><br>";
            }
            String string4 = "<html>" + GuiConstants.createMessage(setting.getRuntime().getDisplayText()) + "<br><br>" + string2 + "<br><br>" + string3 + "</html>";
            string4 = Util.getSplitLines(string4);
            JOptionPane.showMessageDialog(this, string4, "Help", 1);
        }
        if (string != null && string.length() > 0) {
            try {
                this.cls_OsProvider.openBrowser(string);
            }
            catch (Exception exception) {
                log.error((Object)("Unable to open browser to " + string), (Throwable)exception);
                JOptionPane.showMessageDialog(this, "An error occurred while attempting to open the browser to " + string + ".");
            }
        }
    }

    public static class ManualRepairHeaderPanel
    extends JPanel {
        public static final long serialVersionUID = 1L;
        private final JPanel cls_ButtonPanel = new JPanel();

        public ManualRepairHeaderPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)new JLabel(GuiConstants.getImage("/info.gif")), "West");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)new XpcSpacer(20, 1), "West");
            jPanel.add((Component)new XpcSpacer(20, 1), "East");
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel("<html>The following settings need to be corrected on your machine.  Click <b>Fix All</b> to allow the wizard to correct these items automatically.  If you manually correct items, click <b>Refresh</b> to reevaluate.</html>");
            jPanel.add((Component)jLabel, "Center");
            this.add((Component)jPanel, "Center");
            this.cls_ButtonPanel.setLayout(new BoxLayout(this.cls_ButtonPanel, 1));
            this.cls_ButtonPanel.setOpaque(false);
            this.add((Component)this.cls_ButtonPanel, "East");
            this.cls_ButtonPanel.add(new XpcSpacer(1, 4));
        }

        public JPanel addButton(String string, String string2, ActionListener actionListener, String string3) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            XpcButtonPanel.XpcButton xpcButton = new XpcButtonPanel.XpcButton(string, null);
            xpcButton.addActionListener(actionListener);
            xpcButton.setActionCommand(string2);
            xpcButton.setToolTipText(string3);
            jPanel.add(xpcButton);
            jPanel.add(new XpcSpacer(1, 4));
            this.cls_ButtonPanel.add(jPanel);
            return jPanel;
        }

        public JPanel addLink(XpcLink xpcLink) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(xpcLink);
            jPanel.add(new XpcSpacer(1, 4));
            this.cls_ButtonPanel.add(jPanel);
            return jPanel;
        }
    }
}

