/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.KeychainRequest;
import com.cloudpath.app.xpc.workflow.block.selection.RepairSectionSelection;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class MacKeychainForm
extends XpcPromptForm {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MacKeychainForm.class);
    private static final String STANDARD_TITLE = "Keychain Access Unavailable";
    private static final String REPAIR_INSTRUCTIONS = "To repair your keychain, do the following:<br><ul style='margin-left:20px;'><li>Open Keychain Access from Applications/Utilities.</li><li>In the menu, select <b>Keychain Access</b> -> <b>Keychain First Aid</b>.</li><li>Enter your password, select <b>Repair</b> and click the <b>Start</b> button.</li></ul>";
    private static final String RESET_INSTRUCTIONS = "To reset your keychain, do the following:<br><ul style='margin-left:20px;'><li>Open Keychain Access from Applications/Utilities.</li><li>In the menu, select <b>Keychain Access</b> -> <b>Preferences</b>.</li><li>Click the <b>Reset My Keychain</b> button.</li></ul>";
    private static final String IF_PROBLEM_PERSISTS = "<br><br>If the problem persists, you may need to reset your keychain.  Resetting your keychain will cause cached passwords to be cleared.  To reset your keychain, do the following:<br><ul style='margin-left:20px;'><li>Open Keychain Access from Applications/Utilities.</li><li>In the menu, select <b>Keychain Access</b> -> <b>Preferences</b>.</li><li>Click the <b>Reset My Keychain</b> button.</li></ul>";
    private static final HashMap<Integer, String> ERROR_DESCRIPTIONS = new HashMap();
    private final KeychainRequest cls_Request;

    public MacKeychainForm(FormListener formListener, KeychainRequest keychainRequest, ApplicationProvider applicationProvider, SelectionHandler selectionHandler) {
        super(formListener, STANDARD_TITLE, keychainRequest.getSetting() != null ? "Skip" : "", "Retry");
        Object object;
        log.info((Object)"Will show Mac Keychain Form.");
        this.cls_Request = keychainRequest;
        boolean bl = true;
        String string = Resources.ResourceString.PRODUCT_NAME.getValue() + " requires access to the Keychain to configure your computer.  Without a properly configured keychain, you may be asked to authenticate to the network repeatedly.<br><br>";
        if (keychainRequest.getErrorCode() == -128) {
            string = string + "  It appears that the authorization attempt was unsuccessful.  Click 'retry' to try again.  When prompted, select to allow access and if necessary, provide your computer credentials.<br><br>If the problem persists, you may need to reset your keychain.  Resetting your keychain will cause cached passwords to be cleared.  To reset your keychain, do the following:<br><ul style='margin-left:20px;'><li>Open Keychain Access from Applications/Utilities.</li><li>In the menu, select <b>Keychain Access</b> -> <b>Preferences</b>.</li><li>Click the <b>Reset My Keychain</b> button.</li></ul>";
        } else if (keychainRequest.getErrorCode() == -61) {
            string = string + "  It appears that " + Resources.ResourceString.PRODUCT_NAME.getValue() + " was unable to modify the keychain because your login keychain is not writable.  Your login keychain may need repaired or reset.  " + REPAIR_INSTRUCTIONS + "After repairing the keychain, click 'Retry'.  If the problem persists, you may need to reset your keychain to resolve this problem.  Be aware that doing so will cause cached passwords to be removed.  " + RESET_INSTRUCTIONS;
            applicationProvider.launchApplication("Keychain Access");
            bl = false;
        } else {
            object = ERROR_DESCRIPTIONS.get(keychainRequest.getErrorCode());
            string = string + "  An error (" + keychainRequest.getErrorCode() + ") occurred while accessing the keychain.";
            string = object != null ? string + " The error description is '" + (String)object + "'." : string + " This is an unknown error code.";
            string = string + IF_PROBLEM_PERSISTS;
        }
        String string2 = "Computer Username & Password";
        object = new XpcPanel(true);
        ((JComponent)object).setOpaque(false);
        ((Container)object).setLayout(new BorderLayout(0, 0));
        this.add((Component)object, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("<html>" + string + "</html>");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jLabel.setOpaque(false);
        jLabel.setBorder(new MatteBorder(0, 5, 0, 5, (Color)null));
        jLabel.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.setBorder(new MatteBorder(5, 0, 0, 0, (Color)null));
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel2 = new JLabel("<html>If Prompted, Enter Your <font color='red'><b>" + string2 + "</b></font>,</html>");
        jLabel2.setHorizontalAlignment(0);
        jPanel2.add((Component)jLabel2, "Center");
        JLabel jLabel3 = new JLabel("Not Your Network Password");
        jLabel3.setHorizontalAlignment(0);
        jPanel2.add((Component)jLabel3, "South");
        if (bl) {
            jPanel.add((Component)jPanel2, "South");
        }
        ((Container)object).add((Component)jPanel, "Center");
    }

    public void backClicked() {
        this.cls_Request.getSetting().getRuntime().setWasSkipped(true);
        this.selectionMade(new SkipSelection("User chose to skip."));
    }

    public void nextClicked() {
        this.selectionMade(new RepairSectionSelection(RepairSectionSelection.Action.REPAIR));
    }

    public DispatchResponse getSelection() {
        return null;
    }

    static {
        ERROR_DESCRIPTIONS.put(-25291, "No keychain is available.  You may need to restart your computer.");
        ERROR_DESCRIPTIONS.put(-25292, "The keychain cannot be modified.");
        ERROR_DESCRIPTIONS.put(-25293, "The user name or passphrase you entered is not correct.");
        ERROR_DESCRIPTIONS.put(-25294, "The specified keychain could not be found.");
        ERROR_DESCRIPTIONS.put(-25295, "The specified keychain is not a valid keychain file.");
        ERROR_DESCRIPTIONS.put(-25296, "A keychain with the same name already exists.");
        ERROR_DESCRIPTIONS.put(-25297, "The specified callback function is already installed.");
        ERROR_DESCRIPTIONS.put(-25298, "The specified callback function is not valid");
        ERROR_DESCRIPTIONS.put(-25299, "The specified item already exists in the keychain.");
        ERROR_DESCRIPTIONS.put(-25300, "The specified item could not be found in the keychain.");
        ERROR_DESCRIPTIONS.put(-25301, "There is not enough memory available to use the specified item.");
        ERROR_DESCRIPTIONS.put(-25302, "This item contains information which is too large or in a format that cannot be displayed.");
        ERROR_DESCRIPTIONS.put(-25303, "The specified attribute does not exist.");
        ERROR_DESCRIPTIONS.put(-25304, "The specified item is no longer valid.  It may have been deleted from the keychain.");
        ERROR_DESCRIPTIONS.put(-25305, "Unable to search the current keychain.");
        ERROR_DESCRIPTIONS.put(-25306, "The specified item does not appear to be a valid keychain item.");
        ERROR_DESCRIPTIONS.put(-25307, "A default keychain could not be found.");
        ERROR_DESCRIPTIONS.put(-25308, "User interaction is not allowed.");
        ERROR_DESCRIPTIONS.put(-25309, "The specified attribute could not be modified.");
        ERROR_DESCRIPTIONS.put(-25310, "This keychain was created by a different version of the system software and cannot be opened.");
        ERROR_DESCRIPTIONS.put(-25311, "This item specifies a key size which is too large.");
        ERROR_DESCRIPTIONS.put(-25312, "A required component (data storage module) could not be loaded.  You may need to restart your computer.");
        ERROR_DESCRIPTIONS.put(-25313, "A required component (certificate module) could not be loaded.  You may need to restart your computer.");
        ERROR_DESCRIPTIONS.put(-25314, "A required component (policy module) could not be loaded.  You may need to restart your computer.");
        ERROR_DESCRIPTIONS.put(-25315, "User interaction is required, but is currently not allowed.");
        ERROR_DESCRIPTIONS.put(-25316, "The contents of this item cannot be retrieved.");
        ERROR_DESCRIPTIONS.put(-25317, "The contents of this item cannot be modified.");
        ERROR_DESCRIPTIONS.put(-25318, "One or more certificates required to validate this certificate cannot be found.");
        ERROR_DESCRIPTIONS.put(-25319, "The specified preferences domain is not valid.");
        ERROR_DESCRIPTIONS.put(-25340, "The specified access control list is not in standard (simple) format.");
        ERROR_DESCRIPTIONS.put(-25341, "The specified policy cannot be found.");
        ERROR_DESCRIPTIONS.put(-25342, "The specified trust setting is invalid.");
        ERROR_DESCRIPTIONS.put(-25343, "The specified item has no access control.");
        ERROR_DESCRIPTIONS.put(-25344, "Invalid attempt to change the owner of this item.");
        ERROR_DESCRIPTIONS.put(-25345, "No trust results are available.");
        ERROR_DESCRIPTIONS.put(-25356, "Import/Export format unsupported.");
        ERROR_DESCRIPTIONS.put(-25357, "Unknown format for import.");
        ERROR_DESCRIPTIONS.put(-25358, "Key material must be wrapped for export.");
        ERROR_DESCRIPTIONS.put(-25359, "An attempt was made to import multiple private keys.");
        ERROR_DESCRIPTIONS.put(-25360, "Passphrase is required for import/export.");
        ERROR_DESCRIPTIONS.put(-25361, "The password reference was invalid.");
        ERROR_DESCRIPTIONS.put(-25362, "The Turst Settings Record was corrupted.");
        ERROR_DESCRIPTIONS.put(-25363, "No Trust Settings wer found.");
        ERROR_DESCRIPTIONS.put(-25364, "MAC verification failed during PKCS12 import.");
    }
}

