/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.workflow.block.request.LocationRequest;
import com.cloudpath.app.xpc.workflow.block.selection.LocationSelection;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPanel;
import com.cloudpath.gui.component.XpcPartialLinkLabel;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class LocationPromptForm
extends XpcPromptForm
implements XpcLinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LocationPromptForm.class);
    private static final String CREATE_NEW_LOCATION = "Create New Location...";
    private static final int LINK_REFRESH = 2;
    private final JComboBox cls_ExistingLocation;
    private final JLabel cls_ErrorMessage;
    private final SnowLeopardNetworkSetupReader cls_NetworkSetup;
    private String cls_PreviousLocation = "";
    private final XpcPartialLinkLabel cls_LinkLabel = new XpcPartialLinkLabel();

    public LocationPromptForm(FormListener formListener, LocationRequest locationRequest, SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader) {
        super(formListener, "Select the location for this network:", "< Back", "Continue >");
        this.cls_NetworkSetup = snowLeopardNetworkSetupReader;
        XpcPanel xpcPanel = new XpcPanel(true);
        this.add((Component)xpcPanel, "Center");
        String string = this.cls_NetworkSetup.getCurrentLocation();
        String string2 = "Your computer currently has multiple network locations defined.  The current location is '" + string + "'.  We may add the new network to this location or you may select a different location below.  If uncertain, select '" + string + "'.";
        JLabel jLabel = new JLabel("<html>" + string2 + "</html>");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jLabel.setOpaque(false);
        jLabel.setBorder(new MatteBorder(15, 30, 15, 30, (Color)null));
        jLabel.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        xpcPanel.add(jLabel);
        this.cls_ErrorMessage = new JLabel("");
        this.cls_ErrorMessage.setForeground(GuiConstants.COLOR_ERROR);
        this.cls_ErrorMessage.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        this.cls_ErrorMessage.setVisible(false);
        this.cls_ErrorMessage.setBorder(new MatteBorder(7, 30, 7, 30, (Color)null));
        GuiConstants.makeBold(this.cls_ErrorMessage);
        xpcPanel.add(this.cls_ErrorMessage);
        xpcPanel.add(new XpcSpacer(2, 10));
        Dimension dimension = new Dimension(85, 20);
        String string3 = "Location: ";
        JLabel jLabel2 = new JLabel(string3);
        jLabel2.setFont(GuiConstants.FONT_ARIAL_11_BOLD);
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setMinimumSize(dimension);
        jLabel2.setMaximumSize(dimension);
        jLabel2.setPreferredSize(dimension);
        this.cls_ExistingLocation = new JComboBox<String>(new String[0]);
        this.cls_ExistingLocation.setSelectedItem(string);
        this.refreshLocations(string);
        this.cls_ExistingLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = LocationPromptForm.this.cls_ExistingLocation.getSelectedItem();
                log.debug((Object)("  - User selected: " + object));
                if (LocationPromptForm.CREATE_NEW_LOCATION.equals(object)) {
                    log.debug((Object)"  - Will prompt user for name of new location...");
                    String string = JOptionPane.showInputDialog(null, "Location Name:", "Create New Location", 1);
                    if (string != null && string.length() > 0) {
                        log.debug((Object)("  - Will create new location named '" + string + "'."));
                        LocationPromptForm.this.cls_NetworkSetup.addLocation(string);
                        LocationPromptForm.this.refreshLocations(string);
                    } else {
                        log.debug((Object)("  - User cancelled new location.  Will change selection back to: " + LocationPromptForm.this.cls_PreviousLocation));
                        LocationPromptForm.this.cls_ExistingLocation.setSelectedItem(LocationPromptForm.this.cls_PreviousLocation);
                    }
                } else if (object instanceof String) {
                    LocationPromptForm.this.cls_PreviousLocation = (String)object;
                }
            }
        });
        XpcPanel xpcPanel2 = new XpcPanel();
        ((BorderLayout)xpcPanel2.getLayout()).setHgap(20);
        xpcPanel2.setMaximumSize(new Dimension(2000, 20));
        xpcPanel2.setPreferredSize(new Dimension(2000, 20));
        xpcPanel2.add(new XpcSpacer(6, 2));
        xpcPanel2.add((Component)jLabel2, "West");
        xpcPanel2.add((Component)this.cls_ExistingLocation, "Center");
        xpcPanel2.add((Component)new XpcSpacer(20, 2), "East");
        xpcPanel2.setAlignmentX(0.0f);
        xpcPanel.add(xpcPanel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        xpcPanel.add(jPanel);
        this.cls_LinkLabel.addLink("Refresh", 2, this);
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(this.cls_LinkLabel);
        jPanel.setVisible(true);
        xpcPanel.add(jPanel);
    }

    public DispatchResponse getSelection() {
        Object object = this.cls_ExistingLocation.getSelectedItem();
        log.debug((Object)("Getting selection.  User selected: " + object));
        if (object != null && object instanceof String) {
            if (object.equals(this.cls_NetworkSetup.getCurrentLocation())) {
                log.info((Object)("Will use current location '" + object + "'."));
            } else {
                log.warn((Object)("Will switch to location '" + object + "."));
                this.cls_NetworkSetup.switchLocation((String)object);
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object.equals(this.cls_NetworkSetup.getCurrentLocation())) {
                    log.debug((Object)"  - Successfully switched location.");
                } else {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object.equals(this.cls_NetworkSetup.getCurrentLocation())) {
                        log.debug((Object)"  - Successfully switched location after waiting longer.");
                    } else {
                        log.error((Object)("We failed to switch to the location '" + object + "'."));
                        this.showError("Failed to switch to location '" + object + "'.");
                        return null;
                    }
                }
            }
            return new LocationSelection(object.toString());
        }
        log.error((Object)("Selected location is: " + object + ".  Type is " + Util.getClassName(object)));
        return new LocationSelection("");
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        xpcFocusTraversalPolicy.addComponent(this.cls_ExistingLocation);
        super.populateFocusTraversal(xpcFocusTraversalPolicy);
    }

    public void doFocus() {
        this.cls_ExistingLocation.requestFocus();
    }

    private void showError(String string) {
        log.info((Object)("Showing error '" + string + "'."));
        this.cls_ErrorMessage.setText("<html>" + string + "</html>");
        this.cls_ErrorMessage.setVisible(true);
    }

    public void refreshLocations(String string) {
        String[] stringArray = this.cls_NetworkSetup.getAllLocations();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = CREATE_NEW_LOCATION;
        this.cls_ExistingLocation.removeAllItems();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.cls_ExistingLocation.addItem(stringArray2[i]);
        }
        this.cls_ExistingLocation.setSelectedItem(string);
        this.cls_PreviousLocation = string;
    }

    public void linkClicked(int n) {
        if (n == 2) {
            this.refreshLocations(this.cls_PreviousLocation);
        }
    }
}

