/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui.form;

import com.cloudpath.app.xpc.gui.form.control.ViewModifications;
import com.cloudpath.app.xpc.workflow.block.request.NotifyConnectedRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.dispatch.TerminateSelection;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.StatusPanel;
import com.cloudpath.gui.component.XpcHtmlPanel;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.workflow.common.block.selection.RemoveSelection;
import com.cloudpath.workflow.common.block.selection.StartOverSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class ConnectedForm
extends XpcPromptForm
implements HyperlinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ConnectedForm.class);
    private static final String LINK_VIEW_MODS = "CPN_VIEW_MODS";
    private static final String LINK_REVERT_NOW = "CPN_REVERT_NOW";
    private static final String TEXT_CONNECTED_SUCCESSFULLY = "Successfully connected.";
    private static final String TEXT_CONFIGURED_SUCCESSFULLY = "Successfully configured.";
    private static final String TEXT_CONNECTED_PARTIALLY = "Partially connected.";
    private static final String TEXT_CONNECTED = "You are now connected to the network.////Your IP address is ${IP_ADDRESS}.";
    private static final String TEXT_CONNECTED_WITH_SKIPS = "You have now completed the wizard, but steps were skipped which may prevent the network connection from functioning properly.////${SKIPPED_ITEMS}////Your IP address is ${IP_ADDRESS}.";
    private static final String TEXT_CONNECTED_NO_MODIFICATIONS = "////No modifications were made to your machine.";
    private static final String TEXT_CONFIGURED = "You are now configured for the network.";
    private final XpcHtmlPanel cls_Display;
    private final NotifyConnectedRequest cls_Request;

    public ConnectedForm(FormListener formListener, NotifyConnectedRequest notifyConnectedRequest) {
        super(formListener, (JPanel)null, "", "Done");
        String string;
        String string2;
        String string3;
        boolean bl = !notifyConnectedRequest.getVerificationSkipped();
        this.cls_Request = notifyConnectedRequest;
        this.cls_Display = new XpcHtmlPanel(this);
        this.cls_Display.setBorder(new MatteBorder(10, 20, 0, 0, (Color)null));
        this.cls_Display.setFont(GuiConstants.FONT_ARIAL_12_PLAIN);
        if (!notifyConnectedRequest.getMigrationBehavior()) {
            string3 = this.getCompletionText(TEXT_CONFIGURED, notifyConnectedRequest.getSkipMessages(), notifyConnectedRequest.getIpAddress());
            string2 = TEXT_CONFIGURED_SUCCESSFULLY;
            string = "/success.gif";
        } else if (bl) {
            string3 = this.getCompletionText(TEXT_CONNECTED, notifyConnectedRequest.getSkipMessages(), notifyConnectedRequest.getIpAddress());
            string2 = TEXT_CONNECTED_SUCCESSFULLY;
            string = "/success.gif";
        } else {
            string3 = this.getCompletionText(TEXT_CONNECTED_WITH_SKIPS, notifyConnectedRequest.getSkipMessages(), notifyConnectedRequest.getIpAddress());
            string2 = TEXT_CONNECTED_PARTIALLY;
            string = "/warning.gif";
        }
        if (notifyConnectedRequest.getRequiredModification()) {
            this.cls_Display.appendMessage(string3);
            this.cls_Display.appendMessage("<br><a href='CPN_VIEW_MODS'>Click here</a> to view the modifications made to your computer.");
            if (notifyConnectedRequest.getAllowRevert()) {
                this.cls_Display.appendMessage("<br>If you wish, you may revert these changes <a href='CPN_REVERT_NOW'>now</a>.");
            }
        } else {
            string3 = string3 + this.getCompletionText(TEXT_CONNECTED_NO_MODIFICATIONS, notifyConnectedRequest.getSkipMessages(), notifyConnectedRequest.getIpAddress());
            this.cls_Display.appendMessage(string3);
        }
        this.add((Component)new StatusPanel(string2, this.cls_Display, string), "Center");
        log.debug((Object)(this.getClass().getSimpleName() + " initialized."));
    }

    public DispatchResponse getSelection() {
        return new TerminateSelection();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            if (LINK_VIEW_MODS.equals(hyperlinkEvent.getDescription())) {
                Container container = this.getParent();
                this.getParent().remove(this);
                container.add((Component)new ViewModifications(this, this.cls_Request.getModifications(), this.cls_Request.getRequiredModification() && this.cls_Request.getAllowRevert()), "Center");
                container.validate();
            } else if (LINK_REVERT_NOW.equals(hyperlinkEvent.getDescription())) {
                this.selectionMade(new StartOverSelection(StartingPoint.REVERT));
            }
        }
    }

    public boolean selectionMade(DispatchResponse dispatchResponse) {
        if (dispatchResponse instanceof RemoveSelection) {
            Container container = ((RemoveSelection)dispatchResponse).getComponent().getParent();
            container.remove(((RemoveSelection)dispatchResponse).getComponent());
            container.add((Component)this, "Center");
            this.validate();
            container.validate();
            container.repaint();
        } else {
            super.selectionMade(dispatchResponse);
        }
        return true;
    }

    private String getCompletionText(String string, String string2, String string3) {
        string2 = string2 == null ? "" : string2.replace("\n", "\n\n");
        string = string.replace("${SKIPPED_ITEMS}", string2);
        if (string3 == null) {
            string3 = "0.0.0.0";
        }
        string = string.replace("${IP_ADDRESS}", string3);
        string = Util.getSplitLines(string);
        return string;
    }
}

