/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc.gui;

import com.cloudpath.assess.util.PojoUtil;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.SkipSelection;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.mac.common.MacOsProvider;
import com.cloudpath.common.pojo.Contact;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.gui.factor.AboutFrame;
import com.cloudpath.gui.factor.HelpdeskFrame;
import com.cloudpath.gui.factor.LogFrame;
import com.cloudpath.gui.util.MenuProvider;
import com.cloudpath.gui.util.MenuUtil;
import com.cloudpath.workflow.common.block.selection.StartOverSelection;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class XpcMenuProvider
implements MenuProvider {
    private static final Logger log = Logger.getLogger(XpcMenuProvider.class);
    private static final String ACTION_START_OVER = "START_OVER";
    private static final String ACTION_REVERT = "REVERT";
    private static final String ACTION_HELPDESK = "HELPDESK";
    private static final String ACTION_ABOUT = "ABOUT";
    private static final String ACTION_LOG = "LOG";
    private static final String ACTION_GENERATE_SUPPORT = "SUPPORT";
    private static final String ACTION_FIX_MACCMD = "MACCMD";
    private static final String ACTION_SKIP = "SKIP";
    private final AsyncHandler cls_AsyncHandler;
    private final OsProvider cls_OsProvider;
    private final SelectionHandler cls_SelectionHandler;
    private final LogFrame cls_LogFrame = new LogFrame();
    private AboutFrame cls_AboutFrame = null;
    private HelpdeskFrame cls_HelpdeskFrame = null;
    private JMenu cls_OptionsMenu;

    public XpcMenuProvider(AsyncHandler asyncHandler, OsProvider osProvider, SelectionHandler selectionHandler) {
        this.cls_AsyncHandler = asyncHandler;
        this.cls_OsProvider = osProvider;
        this.cls_SelectionHandler = selectionHandler;
    }

    public void createMenu(JMenuBar jMenuBar, ActionListener actionListener) {
        this.cls_OptionsMenu = MenuUtil.createMenu(jMenuBar, "Options", 79);
        MenuUtil.createMenuItem(this.cls_OptionsMenu, "Start Over", ACTION_START_OVER, actionListener);
        MenuUtil.createMenuItem(this.cls_OptionsMenu, "Revert Previous Changes", ACTION_REVERT, actionListener);
        JMenu jMenu = MenuUtil.createMenu(this.cls_OptionsMenu, "Support", 83);
        MenuUtil.createMenuItem(jMenu, "Show Logs", ACTION_LOG, actionListener);
        MenuUtil.createMenuItem(jMenu, "Generate Support File", ACTION_GENERATE_SUPPORT, actionListener);
        MenuUtil.createMenuItem(jMenu, "Skip Current Step", ACTION_SKIP, actionListener);
        MenuUtil.createMenuItem(jMenu, "Perform Elevation", ACTION_FIX_MACCMD, actionListener);
        JMenu jMenu2 = MenuUtil.createMenu(jMenuBar, "Help", 72);
        MenuUtil.createMenuItem(jMenu2, "Network Helpdesk Contact Information...", ACTION_HELPDESK, actionListener);
        MenuUtil.createMenuItem(jMenu2, "About " + Resources.ResourceString.PRODUCT_NAME.getValue() + "...", ACTION_ABOUT, actionListener);
    }

    public void setOptionsMenu(boolean bl) {
        this.cls_OptionsMenu.setVisible(bl);
    }

    public void menuSelected(Component component, String string) {
        if (ACTION_START_OVER.equals(string)) {
            log.debug((Object)"User requested to start over via the menu.");
            this.cls_AsyncHandler.processAsync(new StartOverSelection(StartingPoint.CONFIGURE));
        } else if (ACTION_REVERT.equals(string)) {
            log.debug((Object)"User requested to revert via the menu.");
            this.cls_AsyncHandler.processAsync(new StartOverSelection(StartingPoint.REVERT));
        } else if (ACTION_SKIP.equals(string)) {
            log.debug((Object)"User requested to skip via the menu.");
            this.cls_AsyncHandler.processAsync(new SkipSelection(""));
        } else if (ACTION_LOG.equals(string)) {
            log.debug((Object)"User selected logs from menu.");
            this.cls_LogFrame.setVisible(!this.cls_LogFrame.isVisible());
        } else if (ACTION_GENERATE_SUPPORT.equals(string)) {
            log.debug((Object)"User selected to generate support file from menu.");
            Contact contact = PojoUtil.getCurrentContact(this.cls_SelectionHandler);
            String string2 = "";
            if (contact != null && contact.getEmail() != null && contact.getEmail().length() > 0) {
                string2 = contact.getEmail() + " or ";
            }
            String string3 = this.cls_OsProvider.generateSupportFile();
            JOptionPane.showMessageDialog(component, "<html>The support file has been generated at " + string3 + ".<br><br>Please email this file to " + string2 + Resources.ResourceString.PRODUCT_SUPPORT_EMAIL.getValue() + ".<br></html>", "Support File", 1);
        } else if (ACTION_FIX_MACCMD.equals(string)) {
            if (this.cls_OsProvider instanceof MacOsProvider) {
                log.info((Object)"\n\n\nWILL INITIALIZE MACCMD: \n");
                ((MacOsProvider)this.cls_OsProvider).getMaccmd().installForAdminUser(true);
                log.info((Object)"\n\n\nWILL VERIFY MACCMD: \n");
                ((MacOsProvider)this.cls_OsProvider).getMaccmd().verify(null, null, true);
            }
        } else if (ACTION_ABOUT.equals(string)) {
            log.debug((Object)"User requested to display the About dialog.");
            if (this.cls_AboutFrame == null) {
                this.cls_AboutFrame = new AboutFrame();
            }
            this.cls_AboutFrame.setVisible(true);
        } else if (ACTION_HELPDESK.equals(string)) {
            log.debug((Object)"User requested to display the Helpdesk dialog.");
            if (this.cls_HelpdeskFrame != null) {
                this.cls_HelpdeskFrame.dispose();
            }
            Contact contact = PojoUtil.getCurrentContact(this.cls_SelectionHandler);
            this.cls_HelpdeskFrame = new HelpdeskFrame(this.cls_OsProvider, contact);
            this.cls_HelpdeskFrame.setVisible(true);
        }
    }
}

