/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.app.xpc;

import com.cloudpath.app.common.LaunchUtil;
import com.cloudpath.app.xpc.launch.ElCapitanXpressConnect;
import com.cloudpath.app.xpc.launch.LeopardXpressConnect;
import com.cloudpath.app.xpc.launch.LionXpressConnect;
import com.cloudpath.app.xpc.launch.MavericksXpressConnect;
import com.cloudpath.app.xpc.launch.MountainLionXpressConnect;
import com.cloudpath.app.xpc.launch.SnowLeopardXpressConnect;
import com.cloudpath.app.xpc.launch.TigerXpressConnect;
import com.cloudpath.app.xpc.launch.UnsupportedXpressConnect;
import com.cloudpath.app.xpc.launch.XpressConnect;
import com.cloudpath.app.xpc.launch.YosemiteXpressConnect;
import com.cloudpath.common.app.Controller;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.OsInfo;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.WizardUtil;
import com.cloudpath.gui.factor.LogFrame;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Launch {
    private static final Logger log = Logger.getLogger(Launch.class.getName());
    public static final String ARG_ENROLLMENT_GUID = "enrollmentGuid";
    public static final String ARG_AUTHORIZATION_TOKEN = "authorizationToken";

    public static final void main(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && "-reconnect".equals(stringArray[0])) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            com.cloudpath.app.reconnector.Launch.main(stringArray2);
            return;
        }
        GuiShutdownListener guiShutdownListener = new GuiShutdownListener(){

            public void shutdown() {
                System.exit(0);
            }
        };
        try {
            Launch.mainInternal(stringArray, guiShutdownListener);
        }
        catch (Exception exception) {
            LogFrame logFrame = new LogFrame();
            logFrame.setMessage("An error occurred during loading:\n\n" + Util.getStackTrace(exception));
            logFrame.setVisible(true);
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public static final void mainInternal(String[] stringArray, GuiShutdownListener guiShutdownListener) throws Exception {
        Object object;
        log.log(Level.FINEST, "Launching...");
        log.log(Level.FINEST, "System Properties: " + System.getProperties());
        LaunchUtil.setLookAndFeel();
        XpressConnect xpressConnect = null;
        if (OsConstants.isMacTiger()) {
            log.info("System is Mac Tiger.");
            xpressConnect = new TigerXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacLeopard()) {
            log.info("System is Mac Leopard.");
            xpressConnect = new LeopardXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacSnowLeopard()) {
            log.info("System is Mac Snow Leopard.");
            xpressConnect = new SnowLeopardXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacLion()) {
            log.info("System is Mac Lion.");
            xpressConnect = new LionXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacMountainLion()) {
            log.info("System is Mac Mountain Lion.");
            xpressConnect = new MountainLionXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacMavericks()) {
            log.info("System is Mac Mavericks.");
            xpressConnect = new MavericksXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacYosemite()) {
            log.info("System is Mac Yosemite.");
            xpressConnect = new YosemiteXpressConnect(stringArray, guiShutdownListener);
        } else if (OsConstants.isMacElCapitan()) {
            log.info("System is Mac El Capitan.");
            xpressConnect = new ElCapitanXpressConnect(stringArray, guiShutdownListener);
        } else {
            System.err.println("Unknown operating system: " + OsInfo.getInfo());
            xpressConnect = new UnsupportedXpressConnect(stringArray, guiShutdownListener);
        }
        String string = "";
        String string2 = "";
        Arguments arguments = new Arguments(stringArray);
        if (arguments.getUsername() != null && arguments.getUsername().length() > 0) {
            string = arguments.getUsername();
        }
        if (arguments.getPassword() != null && arguments.getPassword().length() > 0) {
            string2 = arguments.getPassword();
        }
        log.info("Will check for session information...");
        try {
            object = FileUtil.read("session.properties");
            log.info("Session information: " + (String)object);
            if (object != null) {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(((String)object).getBytes()));
                if (properties.containsKey(ARG_ENROLLMENT_GUID) && properties.containsKey(ARG_AUTHORIZATION_TOKEN)) {
                    log.info("Session information found...");
                    String string3 = (String)properties.get(ARG_ENROLLMENT_GUID);
                    String string4 = (String)properties.get(ARG_AUTHORIZATION_TOKEN);
                    if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                        log.info("Session information loaded.");
                        string = string3;
                        string2 = string4;
                        WizardUtil.setIsEnrollmentSystem(true, string3, string4);
                        log.info("Enrollment GUID: " + WizardUtil.getEnrollmentGuid());
                        log.info("Authorization Token: " + WizardUtil.getAuthorizationToken());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            log.info("Did not locate session.properties.");
        }
        xpressConnect.setParams(string, string2);
        object = new Controller(xpressConnect, guiShutdownListener);
        ((Controller)object).waitFor();
    }
}

